@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationBatchStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property urls The operation url of long running operation
 * @property userName The name of the user.
 */
public data class GetGlobalUserOperationBatchStatusPlainArgs(
    public val urls: List<String>,
    public val userName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationBatchStatusPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationBatchStatusPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationBatchStatusPlainArgs.builder()
            .urls(urls.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalUserOperationBatchStatusPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalUserOperationBatchStatusPlainArgsBuilder internal constructor() {
    private var urls: List<String>? = null

    private var userName: String? = null

    /**
     * @param value The operation url of long running operation
     */
    @JvmName("fkcxhjbmgbjqkdcm")
    public suspend fun urls(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.urls = mapped
    }

    /**
     * @param values The operation url of long running operation
     */
    @JvmName("mgxfedtgabpjqlhw")
    public suspend fun urls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.urls = mapped
    }

    /**
     * @param value The name of the user.
     */
    @JvmName("fshhtqykuauylvul")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetGlobalUserOperationBatchStatusPlainArgs =
        GetGlobalUserOperationBatchStatusPlainArgs(
            urls = urls ?: throw PulumiNullFieldException("urls"),
            userName = userName ?: throw PulumiNullFieldException("userName"),
        )
}
