@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scheduleName The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
 */
public data class GetSchedulePlainArgs(
    public val labName: String,
    public val resourceGroupName: String,
    public val scheduleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetSchedulePlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetSchedulePlainArgs.builder()
            .labName(labName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scheduleName(scheduleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetSchedulePlainArgsBuilder internal constructor() {
    private var labName: String? = null

    private var resourceGroupName: String? = null

    private var scheduleName: String? = null

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("ampmqjhrvrumprxy")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fixncqjfmftrilfj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("eipuldjyaywxskea")
    public suspend fun scheduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scheduleName = mapped
    }

    internal fun build(): GetSchedulePlainArgs = GetSchedulePlainArgs(
        labName = labName ?: throw PulumiNullFieldException("labName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scheduleName = scheduleName ?: throw PulumiNullFieldException("scheduleName"),
    )
}
