@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property userName The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
 */
public data class GetUserPlainArgs(
    public val labName: String,
    public val resourceGroupName: String,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetUserPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetUserPlainArgs.builder()
            .labName(labName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var labName: String? = null

    private var resourceGroupName: String? = null

    private var userName: String? = null

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("bxivnbdumlvetryw")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("htcivfhkwjdvmyvk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("rnkoujcyiudjwlcf")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        labName = labName ?: throw PulumiNullFieldException("labName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
