@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.LabNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Profile for how to handle networking for Labs.
 * @property loadBalancerId The external load balancer resource id
 * @property publicIpId The external public IP resource id
 * @property subnetId The external subnet resource id
 */
public data class LabNetworkProfileArgs(
    public val loadBalancerId: Output<String>? = null,
    public val publicIpId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.LabNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.LabNetworkProfileArgs =
        com.pulumi.azurenative.labservices.inputs.LabNetworkProfileArgs.builder()
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .publicIpId(publicIpId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabNetworkProfileArgs].
 */
@PulumiTagMarker
public class LabNetworkProfileArgsBuilder internal constructor() {
    private var loadBalancerId: Output<String>? = null

    private var publicIpId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The external load balancer resource id
     */
    @JvmName("yftqojwscoswewed")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value The external public IP resource id
     */
    @JvmName("thwhitfasrokhbxb")
    public suspend fun publicIpId(`value`: Output<String>) {
        this.publicIpId = value
    }

    /**
     * @param value The external subnet resource id
     */
    @JvmName("umhnktxmvjqoudfm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The external load balancer resource id
     */
    @JvmName("qtbjyhnpqsyvhtla")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value The external public IP resource id
     */
    @JvmName("vhtibcrlbginesqk")
    public suspend fun publicIpId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpId = mapped
    }

    /**
     * @param value The external subnet resource id
     */
    @JvmName("mxsbiywwcxwjwnul")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): LabNetworkProfileArgs = LabNetworkProfileArgs(
        loadBalancerId = loadBalancerId,
        publicIpId = publicIpId,
        subnetId = subnetId,
    )
}
