@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ResourceSettingsArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.ManagedLabVmSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents resource specific settings
 * @property galleryImageResourceId The resource id of the gallery image used for creating the virtual machine
 * @property referenceVm Details specific to Reference Vm
 * @property size The size of the virtual machine
 */
public data class ResourceSettingsArgs(
    public val galleryImageResourceId: Output<String>? = null,
    public val referenceVm: Output<ReferenceVmArgs>,
    public val size: Output<Either<String, ManagedLabVmSize>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ResourceSettingsArgs =
        com.pulumi.azurenative.labservices.inputs.ResourceSettingsArgs.builder()
            .galleryImageResourceId(galleryImageResourceId?.applyValue({ args0 -> args0 }))
            .referenceVm(referenceVm.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(
                size?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceSettingsArgs].
 */
@PulumiTagMarker
public class ResourceSettingsArgsBuilder internal constructor() {
    private var galleryImageResourceId: Output<String>? = null

    private var referenceVm: Output<ReferenceVmArgs>? = null

    private var size: Output<Either<String, ManagedLabVmSize>>? = null

    /**
     * @param value The resource id of the gallery image used for creating the virtual machine
     */
    @JvmName("yavbonnygwnngdmd")
    public suspend fun galleryImageResourceId(`value`: Output<String>) {
        this.galleryImageResourceId = value
    }

    /**
     * @param value Details specific to Reference Vm
     */
    @JvmName("xicfbvgpespudjtu")
    public suspend fun referenceVm(`value`: Output<ReferenceVmArgs>) {
        this.referenceVm = value
    }

    /**
     * @param value The size of the virtual machine
     */
    @JvmName("qpkdieuqcncpdxoe")
    public suspend fun size(`value`: Output<Either<String, ManagedLabVmSize>>) {
        this.size = value
    }

    /**
     * @param value The resource id of the gallery image used for creating the virtual machine
     */
    @JvmName("vhtgvhcsmerputdq")
    public suspend fun galleryImageResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageResourceId = mapped
    }

    /**
     * @param value Details specific to Reference Vm
     */
    @JvmName("ovrrudydvffygdbq")
    public suspend fun referenceVm(`value`: ReferenceVmArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceVm = mapped
    }

    /**
     * @param argument Details specific to Reference Vm
     */
    @JvmName("iicvtmiirljwhsiu")
    public suspend fun referenceVm(argument: suspend ReferenceVmArgsBuilder.() -> Unit) {
        val toBeMapped = ReferenceVmArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referenceVm = mapped
    }

    /**
     * @param value The size of the virtual machine
     */
    @JvmName("dixndchexeiaslxl")
    public suspend fun size(`value`: Either<String, ManagedLabVmSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The size of the virtual machine
     */
    @JvmName("mwhacwqoddlmpfka")
    public fun size(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedLabVmSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The size of the virtual machine
     */
    @JvmName("jrtpeifkbwetjvcq")
    public fun size(`value`: ManagedLabVmSize) {
        val toBeMapped = Either.ofRight<String, ManagedLabVmSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): ResourceSettingsArgs = ResourceSettingsArgs(
        galleryImageResourceId = galleryImageResourceId,
        referenceVm = referenceVm ?: throw PulumiNullFieldException("referenceVm"),
        size = size,
    )
}
