@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.VirtualMachineAdditionalCapabilitiesArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.EnableState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The additional capabilities for a lab VM.
 * @property installGpuDrivers Flag to pre-install dedicated GPU drivers.
 */
public data class VirtualMachineAdditionalCapabilitiesArgs(
    public val installGpuDrivers: Output<EnableState>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.VirtualMachineAdditionalCapabilitiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.VirtualMachineAdditionalCapabilitiesArgs =
        com.pulumi.azurenative.labservices.inputs.VirtualMachineAdditionalCapabilitiesArgs.builder()
            .installGpuDrivers(
                installGpuDrivers?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineAdditionalCapabilitiesArgs].
 */
@PulumiTagMarker
public class VirtualMachineAdditionalCapabilitiesArgsBuilder internal constructor() {
    private var installGpuDrivers: Output<EnableState>? = null

    /**
     * @param value Flag to pre-install dedicated GPU drivers.
     */
    @JvmName("stdffbgtaclbmjnp")
    public suspend fun installGpuDrivers(`value`: Output<EnableState>) {
        this.installGpuDrivers = value
    }

    /**
     * @param value Flag to pre-install dedicated GPU drivers.
     */
    @JvmName("maavcwbkpwfrpnvk")
    public suspend fun installGpuDrivers(`value`: EnableState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installGpuDrivers = mapped
    }

    internal fun build(): VirtualMachineAdditionalCapabilitiesArgs =
        VirtualMachineAdditionalCapabilitiesArgs(
            installGpuDrivers = installGpuDrivers,
        )
}
