@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a size category supported by this Lab Account (small, medium or large)
 * @property maxPrice The pay-as-you-go dollar price per hour this size will cost. It does not include discounts and may not reflect the actual price the size will cost. This is the maximum price of all prices within this tier.
 * @property minMemory The amount of memory available (in GB). This is the minimum amount of memory within this tier.
 * @property minNumberOfCores The number of cores a VM of this size has. This is the minimum number of cores within this tier.
 * @property name The size category
 * @property vmSizes Represents a set of compute sizes that can serve this given size type
 */
public data class EnvironmentSizeResponse(
    public val maxPrice: Double,
    public val minMemory: Double,
    public val minNumberOfCores: Int,
    public val name: String? = null,
    public val vmSizes: List<SizeInfoResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.EnvironmentSizeResponse):
            EnvironmentSizeResponse = EnvironmentSizeResponse(
            maxPrice = javaType.maxPrice(),
            minMemory = javaType.minMemory(),
            minNumberOfCores = javaType.minNumberOfCores(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            vmSizes = javaType.vmSizes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.SizeInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
