@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a lab account.
 * @property enabledRegionSelection Represents if region selection is enabled
 * @property id The identifier of the resource.
 * @property latestOperationResult The details of the latest operation. ex: status, error
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property sizeConfiguration Represents the size configuration under the lab account
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetLabAccountResult(
    public val enabledRegionSelection: Boolean? = null,
    public val id: String,
    public val latestOperationResult: LatestOperationResultResponse,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String? = null,
    public val sizeConfiguration: SizeConfigurationPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetLabAccountResult):
            GetLabAccountResult = GetLabAccountResult(
            enabledRegionSelection = javaType.enabledRegionSelection().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            latestOperationResult = javaType.latestOperationResult().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            sizeConfiguration = javaType.sizeConfiguration().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SizeConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
