@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schedule for automatically turning virtual machines in a lab on and off at specified times.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property notes Notes for this schedule.
 * @property provisioningState Current provisioning state of the schedule.
 * @property recurrencePattern The recurrence pattern of the scheduled actions.
 * @property startAt When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
 * @property stopAt When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
 * @property systemData Metadata pertaining to creation and last modification of the schedule.
 * @property timeZoneId The IANA timezone id for the schedule.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetScheduleResult(
    public val id: String,
    public val name: String,
    public val notes: String? = null,
    public val provisioningState: String,
    public val recurrencePattern: RecurrencePatternResponse? = null,
    public val startAt: String? = null,
    public val stopAt: String,
    public val systemData: SystemDataResponse,
    public val timeZoneId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetScheduleResult):
            GetScheduleResult = GetScheduleResult(
            id = javaType.id(),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            recurrencePattern = javaType.recurrencePattern().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.RecurrencePatternResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startAt = javaType.startAt().map({ args0 -> args0 }).orElse(null),
            stopAt = javaType.stopAt(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeZoneId = javaType.timeZoneId(),
            type = javaType.type(),
        )
    }
}
