@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User of a lab that can register for and use virtual machines within the lab.
 * @property additionalUsageQuota The amount of usage quota time the user gets in addition to the lab usage quota.
 * @property displayName Display name of the user, for example user's full name.
 * @property email Email address of the user.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property invitationSent Date and time when the invitation message was sent to the user.
 * @property invitationState State of the invitation message for the user.
 * @property name The name of the resource
 * @property provisioningState Current provisioning state of the user resource.
 * @property registrationState State of the user's registration within the lab.
 * @property systemData Metadata pertaining to creation and last modification of the user resource.
 * @property totalUsage How long the user has used their virtual machines in this lab.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUserResult(
    public val additionalUsageQuota: String? = null,
    public val displayName: String,
    public val email: String,
    public val id: String,
    public val invitationSent: String,
    public val invitationState: String,
    public val name: String,
    public val provisioningState: String,
    public val registrationState: String,
    public val systemData: SystemDataResponse,
    public val totalUsage: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetUserResult):
            GetUserResult = GetUserResult(
            additionalUsageQuota = javaType.additionalUsageQuota().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            email = javaType.email(),
            id = javaType.id(),
            invitationSent = javaType.invitationSent(),
            invitationState = javaType.invitationState(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            registrationState = javaType.registrationState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            totalUsage = javaType.totalUsage(),
            type = javaType.type(),
        )
    }
}
