@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The availability information of sizes across regions
 * @property region Corresponding region
 * @property sizeAvailabilities List of all the size information for the region
 */
public data class RegionalAvailabilityResponse(
    public val region: String? = null,
    public val sizeAvailabilities: List<SizeAvailabilityResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.RegionalAvailabilityResponse):
            RegionalAvailabilityResponse = RegionalAvailabilityResponse(
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            sizeAvailabilities = javaType.sizeAvailabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.SizeAvailabilityResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
