@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the backing virtual machine.
 * @property lastKnownPowerState Last known compute power state captured in DTL
 * @property privateIpAddress PrivateIp address of the compute VM
 * @property provisioningState Provisioning state of the Dtl VM
 * @property rdpAuthority Connection information for Windows
 * @property sshAuthority Connection information for Linux
 * @property userName Compute VM login user name
 */
public data class VirtualMachineDetailsResponse(
    public val lastKnownPowerState: String,
    public val privateIpAddress: String,
    public val provisioningState: String,
    public val rdpAuthority: String,
    public val sshAuthority: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.VirtualMachineDetailsResponse):
            VirtualMachineDetailsResponse = VirtualMachineDetailsResponse(
            lastKnownPowerState = javaType.lastKnownPowerState(),
            privateIpAddress = javaType.privateIpAddress(),
            provisioningState = javaType.provisioningState(),
            rdpAuthority = javaType.rdpAuthority(),
            sshAuthority = javaType.sshAuthority(),
            userName = javaType.userName(),
        )
    }
}
