@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin

import com.pulumi.azurenative.loadtestservice.LoadtestserviceFunctions.getLoadTestPlain
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.GetLoadTestPlainArgs
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.GetLoadTestPlainArgsBuilder
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.GetLoadTestResult
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.GetLoadTestResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object LoadtestserviceFunctions {
    /**
     * Get a LoadTest resource.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2021-12-01-preview.
     * @param argument null
     * @return LoadTest details
     */
    public suspend fun getLoadTest(argument: GetLoadTestPlainArgs): GetLoadTestResult =
        toKotlin(getLoadTestPlain(argument.toJava()).await())

    /**
     * @see [getLoadTest].
     * @param loadTestName Load Test name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return LoadTest details
     */
    public suspend fun getLoadTest(loadTestName: String, resourceGroupName: String):
        GetLoadTestResult {
        val argument = GetLoadTestPlainArgs(
            loadTestName = loadTestName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getLoadTestPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadTest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;loadtestservice&#46;kotlin&#46;inputs&#46;GetLoadTestPlainArgs].
     * @return LoadTest details
     */
    public suspend fun getLoadTest(argument: suspend GetLoadTestPlainArgsBuilder.() -> Unit):
        GetLoadTestResult {
        val builder = GetLoadTestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getLoadTestPlain(builtArgument.toJava()).await())
    }
}
