@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.PartnerContentResponse
import com.pulumi.azurenative.logic.kotlin.outputs.PartnerContentResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationAccountPartner].
 */
@PulumiTagMarker
public class IntegrationAccountPartnerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountPartnerArgs = IntegrationAccountPartnerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountPartnerArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountPartnerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationAccountPartner {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountPartner(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountPartner(builtJavaResource)
    }
}

/**
 * The integration account partner.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a partner
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountPartner = new AzureNative.Logic.IntegrationAccountPartner("integrationAccountPartner", new()
 *     {
 *         Content = new AzureNative.Logic.Inputs.PartnerContentArgs
 *         {
 *             B2b = new AzureNative.Logic.Inputs.B2BPartnerContentArgs
 *             {
 *                 BusinessIdentities = new[]
 *                 {
 *                     new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "ZZ",
 *                     },
 *                 },
 *             },
 *         },
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         PartnerName = "testPartner",
 *         PartnerType = "B2B",
 *         ResourceGroupName = "testResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := logic.NewIntegrationAccountPartner(ctx, "integrationAccountPartner", &logic.IntegrationAccountPartnerArgs{
 * Content: logic.PartnerContentResponse{
 * B2b: interface{}{
 * BusinessIdentities: logic.BusinessIdentityArray{
 * &logic.BusinessIdentityArgs{
 * Qualifier: pulumi.String("AA"),
 * Value: pulumi.String("ZZ"),
 * },
 * },
 * },
 * },
 * IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * Location: pulumi.String("westus"),
 * Metadata: nil,
 * PartnerName: pulumi.String("testPartner"),
 * PartnerType: pulumi.String("B2B"),
 * ResourceGroupName: pulumi.String("testResourceGroup"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountPartner;
 * import com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountPartner = new IntegrationAccountPartner("integrationAccountPartner", IntegrationAccountPartnerArgs.builder()
 *             .content(Map.of("b2b", Map.of("businessIdentities", Map.ofEntries(
 *                 Map.entry("qualifier", "AA"),
 *                 Map.entry("value", "ZZ")
 *             ))))
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .partnerName("testPartner")
 *             .partnerType("B2B")
 *             .resourceGroupName("testResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountPartner testPartner /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}
 * ```
 */
public class IntegrationAccountPartner internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountPartner,
) : KotlinCustomResource(javaResource, IntegrationAccountPartnerMapper) {
    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The partner content.
     */
    public val content: Output<PartnerContentResponse>
        get() = javaResource.content().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The partner type.
     */
    public val partnerType: Output<String>
        get() = javaResource.partnerType().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountPartnerMapper : ResourceMapper<IntegrationAccountPartner> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountPartner::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountPartner =
        IntegrationAccountPartner(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountPartner,
        )
}

/**
 * @see [IntegrationAccountPartner].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountPartner].
 */
public suspend fun integrationAccountPartner(
    name: String,
    block: suspend IntegrationAccountPartnerResourceBuilder.() -> Unit,
): IntegrationAccountPartner {
    val builder = IntegrationAccountPartnerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountPartner].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountPartner(name: String): IntegrationAccountPartner {
    val builder = IntegrationAccountPartnerResourceBuilder()
    builder.name(name)
    return builder.build()
}
