@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.SchemaType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account schema.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update schema
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountSchema = new AzureNative.Logic.IntegrationAccountSchema("integrationAccountSchema", new()
 *     {
 *         Content = @"<?xml version=""1.0"" encoding=""utf-16""?>
 * <xs:schema xmlns:b=""http://schemas.microsoft.com/BizTalk/2003"" xmlns=""http://Inbound_EDI.OrderFile"" targetNamespace=""http://Inbound_EDI.OrderFile"" xmlns:xs=""http://www.w3.org/2001/XMLSchema"">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char="" "" count_positions_by_byte=""false"" parser_optimization=""speed"" lookahead_depth=""3"" suppress_empty_nodes=""false"" generate_empty_nodes=""true"" allow_early_termination=""false"" early_terminate_optional_fields=""false"" allow_message_breakup_of_infix_root=""false"" compile_parse_tables=""false"" standard=""Flat File"" root_reference=""OrderFile"" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias=""b"" extensionClass=""Microsoft.BizTalk.FlatFileExtension.FlatFileExtension"" standardName=""Flat File"" xmlns:schemaEditorExtension=""http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions"" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name=""OrderFile"">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" sequence_number=""1"" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number=""0"" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name=""Order"">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number=""1"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""hex"" child_delimiter=""0x0D 0x0A"" child_order=""infix"" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number=""0"" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name=""Header"">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number=""1"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""char"" child_delimiter=""|"" child_order=""infix"" tag_name=""HDR|"" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number=""0"" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name=""PODate"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""1"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""PONumber"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification=""left"" sequence_number=""2"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerID"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""3"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerContactName"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""4"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerContactPhone"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""5"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs=""1"" maxOccurs=""unbounded"" name=""LineItems"">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number=""2"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""char"" child_delimiter=""|"" child_order=""infix"" tag_name=""DTL|"" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number=""0"" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name=""PONumber"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""1"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""ItemOrdered"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""2"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Quantity"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""3"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""UOM"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""4"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Price"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""5"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""ExtendedPrice"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""6"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Description"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""7"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>",
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *         SchemaName = "testSchema",
 *         SchemaType = "Xml",
 *         Tags =
 *         {
 *             { "integrationAccountSchemaName", "IntegrationAccountSchema8120" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountSchema(ctx, "integrationAccountSchema", &logic.IntegrationAccountSchemaArgs{
 * 			Content: pulumi.String(`<?xml version="1.0" encoding="utf-16"?>
 * <xs:schema xmlns:b="http://schemas.microsoft.com/BizTalk/2003" xmlns="http://Inbound_EDI.OrderFile" targetNamespace="http://Inbound_EDI.OrderFile" xmlns:xs="http://www.w3.org/2001/XMLSchema">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char=" " count_positions_by_byte="false" parser_optimization="speed" lookahead_depth="3" suppress_empty_nodes="false" generate_empty_nodes="true" allow_early_termination="false" early_terminate_optional_fields="false" allow_message_breakup_of_infix_root="false" compile_parse_tables="false" standard="Flat File" root_reference="OrderFile" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias="b" extensionClass="Microsoft.BizTalk.FlatFileExtension.FlatFileExtension" standardName="Flat File" xmlns:schemaEditorExtension="http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name="OrderFile">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" sequence_number="1" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number="0" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name="Order">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="hex" child_delimiter="0x0D 0x0A" child_order="infix" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number="0" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name="Header">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="HDR|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PODate" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification="left" sequence_number="2" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerID" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactName" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactPhone" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs="1" maxOccurs="unbounded" name="LineItems">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="2" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="DTL|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ItemOrdered" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="2" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Quantity" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="UOM" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Price" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ExtendedPrice" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="6" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Description" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="7" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>`),
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Metadata:               nil,
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			SchemaName:             pulumi.String("testSchema"),
 * 			SchemaType:             pulumi.String("Xml"),
 * 			Tags: pulumi.StringMap{
 * 				"integrationAccountSchemaName": pulumi.String("IntegrationAccountSchema8120"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountSchema;
 * import com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountSchema = new IntegrationAccountSchema("integrationAccountSchema", IntegrationAccountSchemaArgs.builder()
 *             .content("""
 * <?xml version="1.0" encoding="utf-16"?>
 * <xs:schema xmlns:b="http://schemas.microsoft.com/BizTalk/2003" xmlns="http://Inbound_EDI.OrderFile" targetNamespace="http://Inbound_EDI.OrderFile" xmlns:xs="http://www.w3.org/2001/XMLSchema">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char=" " count_positions_by_byte="false" parser_optimization="speed" lookahead_depth="3" suppress_empty_nodes="false" generate_empty_nodes="true" allow_early_termination="false" early_terminate_optional_fields="false" allow_message_breakup_of_infix_root="false" compile_parse_tables="false" standard="Flat File" root_reference="OrderFile" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias="b" extensionClass="Microsoft.BizTalk.FlatFileExtension.FlatFileExtension" standardName="Flat File" xmlns:schemaEditorExtension="http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name="OrderFile">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" sequence_number="1" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number="0" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name="Order">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="hex" child_delimiter="0x0D 0x0A" child_order="infix" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number="0" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name="Header">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="HDR|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PODate" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification="left" sequence_number="2" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerID" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactName" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactPhone" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs="1" maxOccurs="unbounded" name="LineItems">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="2" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="DTL|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ItemOrdered" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="2" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Quantity" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="UOM" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Price" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ExtendedPrice" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="6" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Description" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="7" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>            """)
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .schemaName("testSchema")
 *             .schemaType("Xml")
 *             .tags(Map.of("integrationAccountSchemaName", "IntegrationAccountSchema8120"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountSchema IntegrationAccountSchema5349 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}
 * ```
 * @property content The content.
 * @property contentType The content type.
 * @property documentName The document name.
 * @property fileName The file name.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property resourceGroupName The resource group name.
 * @property schemaName The integration account schema name.
 * @property schemaType The schema type.
 * @property tags The resource tags.
 * @property targetNamespace The target namespace of the schema.
 */
public data class IntegrationAccountSchemaArgs(
    public val content: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val documentName: Output<String>? = null,
    public val fileName: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val schemaType: Output<Either<String, SchemaType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs =
        com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .documentName(documentName?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .schemaType(
                schemaType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationAccountSchemaArgs].
 */
@PulumiTagMarker
public class IntegrationAccountSchemaArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var documentName: Output<String>? = null

    private var fileName: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var schemaType: Output<Either<String, SchemaType>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetNamespace: Output<String>? = null

    /**
     * @param value The content.
     */
    @JvmName("cearonpeuernikgf")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The content type.
     */
    @JvmName("tejtebevvcionddf")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The document name.
     */
    @JvmName("jflmvebtorywkmmh")
    public suspend fun documentName(`value`: Output<String>) {
        this.documentName = value
    }

    /**
     * @param value The file name.
     */
    @JvmName("mmcxxsndmsjvkasv")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("gfckqncmqlmljmif")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jmxtkaysonlatwqd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("xfoerhyjjmsmqtwg")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hrpxvgskxqmvfnhd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The integration account schema name.
     */
    @JvmName("pvxlaqkrnuxpebvp")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The schema type.
     */
    @JvmName("eyoaqlssakpftvsu")
    public suspend fun schemaType(`value`: Output<Either<String, SchemaType>>) {
        this.schemaType = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("wnigmorvgfwoxlno")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The target namespace of the schema.
     */
    @JvmName("oevuhiwgvimcrdiu")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The content.
     */
    @JvmName("gorjrbxmeamrojjo")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The content type.
     */
    @JvmName("ctksvgqhxinjtiwy")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The document name.
     */
    @JvmName("ixykivvcdxldxxia")
    public suspend fun documentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentName = mapped
    }

    /**
     * @param value The file name.
     */
    @JvmName("yugnevoeawpvyktg")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("ncsukyaoqlnelshc")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("vapwskawuxcwvovv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("vstxvsopubcefuvy")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("cdomyjroiebwhfqn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account schema name.
     */
    @JvmName("cqcsxgbeputivghw")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The schema type.
     */
    @JvmName("wymdnsgpghyqpkei")
    public suspend fun schemaType(`value`: Either<String, SchemaType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value The schema type.
     */
    @JvmName("kotibsthimcoxmni")
    public fun schemaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value The schema type.
     */
    @JvmName("ydcilrseietitmww")
    public fun schemaType(`value`: SchemaType) {
        val toBeMapped = Either.ofRight<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("esriexgtipcwmcoj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("upsbfputfqxajvgq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The target namespace of the schema.
     */
    @JvmName("keejjpsjoexjacku")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): IntegrationAccountSchemaArgs = IntegrationAccountSchemaArgs(
        content = content,
        contentType = contentType,
        documentName = documentName,
        fileName = fileName,
        integrationAccountName = integrationAccountName,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        schemaType = schemaType,
        tags = tags,
        targetNamespace = targetNamespace,
    )
}
