@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationAccountSession].
 */
@PulumiTagMarker
public class IntegrationAccountSessionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountSessionArgs = IntegrationAccountSessionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountSessionArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountSessionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationAccountSession {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountSession(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountSession(builtJavaResource)
    }
}

/**
 * The integration account session.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update an integration account session
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountSession = new AzureNative.Logic.IntegrationAccountSession("integrationAccountSession", new()
 *     {
 *         Content =
 *         {
 *             { "controlNumber", "1234" },
 *             { "controlNumberChangedTime", "2017-02-21T22:30:11.9923759Z" },
 *         },
 *         IntegrationAccountName = "testia123",
 *         ResourceGroupName = "testrg123",
 *         SessionName = "testsession123-ICN",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountSession(ctx, "integrationAccountSession", &logic.IntegrationAccountSessionArgs{
 * 			Content: pulumi.Any{
 * 				ControlNumber:            "1234",
 * 				ControlNumberChangedTime: "2017-02-21T22:30:11.9923759Z",
 * 			},
 * 			IntegrationAccountName: pulumi.String("testia123"),
 * 			ResourceGroupName:      pulumi.String("testrg123"),
 * 			SessionName:            pulumi.String("testsession123-ICN"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountSession;
 * import com.pulumi.azurenative.logic.IntegrationAccountSessionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountSession = new IntegrationAccountSession("integrationAccountSession", IntegrationAccountSessionArgs.builder()
 *             .content(Map.ofEntries(
 *                 Map.entry("controlNumber", "1234"),
 *                 Map.entry("controlNumberChangedTime", "2017-02-21T22:30:11.9923759Z")
 *             ))
 *             .integrationAccountName("testia123")
 *             .resourceGroupName("testrg123")
 *             .sessionName("testsession123-ICN")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountSession testsession123-ICN /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions/{sessionName}
 * ```
 */
public class IntegrationAccountSession internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountSession,
) : KotlinCustomResource(javaResource, IntegrationAccountSessionMapper) {
    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The session content.
     */
    public val content: Output<Any>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountSessionMapper : ResourceMapper<IntegrationAccountSession> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountSession::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountSession =
        IntegrationAccountSession(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountSession,
        )
}

/**
 * @see [IntegrationAccountSession].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountSession].
 */
public suspend fun integrationAccountSession(
    name: String,
    block: suspend IntegrationAccountSessionResourceBuilder.() -> Unit,
): IntegrationAccountSession {
    val builder = IntegrationAccountSessionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountSession].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountSession(name: String): IntegrationAccountSession {
    val builder = IntegrationAccountSessionResourceBuilder()
    builder.name(name)
    return builder.build()
}
