@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentPropertiesArgs
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentPropertiesArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentSkuArgs
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentSkuArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration service environment.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update an integration service environment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationServiceEnvironment = new AzureNative.Logic.IntegrationServiceEnvironment("integrationServiceEnvironment", new()
 *     {
 *         IntegrationServiceEnvironmentName = "testIntegrationServiceEnvironment",
 *         Location = "brazilsouth",
 *         Properties = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentPropertiesArgs
 *         {
 *             EncryptionConfiguration = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs
 *             {
 *                 EncryptionKeyReference = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs
 *                 {
 *                     KeyName = "testKeyName",
 *                     KeyVault = new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault",
 *                     },
 *                     KeyVersion = "13b261d30b984753869902d7f47f4d55",
 *                 },
 *             },
 *             NetworkConfiguration = new AzureNative.Logic.Inputs.NetworkConfigurationArgs
 *             {
 *                 AccessEndpoint = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentAccessEndpointArgs
 *                 {
 *                     Type = "Internal",
 *                 },
 *                 Subnets = new[]
 *                 {
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroup = "testResourceGroup",
 *         Sku = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := logic.NewIntegrationServiceEnvironment(ctx, "integrationServiceEnvironment", &logic.IntegrationServiceEnvironmentArgs{
 * IntegrationServiceEnvironmentName: pulumi.String("testIntegrationServiceEnvironment"),
 * Location: pulumi.String("brazilsouth"),
 * Properties: logic.IntegrationServiceEnvironmentPropertiesResponse{
 * EncryptionConfiguration: interface{}{
 * EncryptionKeyReference: interface{}{
 * KeyName: pulumi.String("testKeyName"),
 * KeyVault: &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault"),
 * },
 * KeyVersion: pulumi.String("13b261d30b984753869902d7f47f4d55"),
 * },
 * },
 * NetworkConfiguration: interface{}{
 * AccessEndpoint: &logic.IntegrationServiceEnvironmentAccessEndpointArgs{
 * Type: pulumi.String("Internal"),
 * },
 * Subnets: logic.ResourceReferenceArray{
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4"),
 * },
 * },
 * },
 * },
 * ResourceGroup: pulumi.String("testResourceGroup"),
 * Sku: &logic.IntegrationServiceEnvironmentSkuArgs{
 * Capacity: pulumi.Int(2),
 * Name: pulumi.String("Premium"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironment;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationServiceEnvironment = new IntegrationServiceEnvironment("integrationServiceEnvironment", IntegrationServiceEnvironmentArgs.builder()
 *             .integrationServiceEnvironmentName("testIntegrationServiceEnvironment")
 *             .location("brazilsouth")
 *             .properties(Map.ofEntries(
 *                 Map.entry("encryptionConfiguration", Map.of("encryptionKeyReference", Map.ofEntries(
 *                     Map.entry("keyName", "testKeyName"),
 *                     Map.entry("keyVault", Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault")),
 *                     Map.entry("keyVersion", "13b261d30b984753869902d7f47f4d55")
 *                 ))),
 *                 Map.entry("networkConfiguration", Map.ofEntries(
 *                     Map.entry("accessEndpoint", Map.of("type", "Internal")),
 *                     Map.entry("subnets",
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4"))
 *                 ))
 *             ))
 *             .resourceGroup("testResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationServiceEnvironment testIntegrationServiceEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Logic/integrationServiceEnvironments/{integrationServiceEnvironmentName}
 * ```
 * @property identity Managed service identity properties.
 * @property integrationServiceEnvironmentName The integration service environment name.
 * @property location The resource location.
 * @property properties The integration service environment properties.
 * @property resourceGroup The resource group.
 * @property sku The sku.
 * @property tags The resource tags.
 */
public data class IntegrationServiceEnvironmentArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val integrationServiceEnvironmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<IntegrationServiceEnvironmentPropertiesArgs>? = null,
    public val resourceGroup: Output<String>? = null,
    public val sku: Output<IntegrationServiceEnvironmentSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs =
        com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integrationServiceEnvironmentName(
                integrationServiceEnvironmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var integrationServiceEnvironmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<IntegrationServiceEnvironmentPropertiesArgs>? = null

    private var resourceGroup: Output<String>? = null

    private var sku: Output<IntegrationServiceEnvironmentSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Managed service identity properties.
     */
    @JvmName("tlmhhvqcuvcquefi")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The integration service environment name.
     */
    @JvmName("twdumpeqvtgwfned")
    public suspend fun integrationServiceEnvironmentName(`value`: Output<String>) {
        this.integrationServiceEnvironmentName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("qucdhjjiraqcgwne")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The integration service environment properties.
     */
    @JvmName("shrtlngyrfnoitpa")
    public suspend fun properties(`value`: Output<IntegrationServiceEnvironmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group.
     */
    @JvmName("nasncxmwohvxsivr")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The sku.
     */
    @JvmName("oktrrctescttsdpj")
    public suspend fun sku(`value`: Output<IntegrationServiceEnvironmentSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("pnafrmlrkvitjpxe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Managed service identity properties.
     */
    @JvmName("kiincoyljgggkohg")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity properties.
     */
    @JvmName("tcjavqejskrhjwhg")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The integration service environment name.
     */
    @JvmName("negawirbvuhqvmll")
    public suspend fun integrationServiceEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironmentName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ckdxmwmcxfkflhuj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The integration service environment properties.
     */
    @JvmName("spfeemdlypsgvnbh")
    public suspend fun properties(`value`: IntegrationServiceEnvironmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The integration service environment properties.
     */
    @JvmName("twjamciylgiigqjl")
    public suspend
    fun properties(argument: suspend IntegrationServiceEnvironmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationServiceEnvironmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group.
     */
    @JvmName("pjjthnkukqwjtbqh")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The sku.
     */
    @JvmName("turnywttsjpiempp")
    public suspend fun sku(`value`: IntegrationServiceEnvironmentSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku.
     */
    @JvmName("sagchlinhsdymtaw")
    public suspend fun sku(argument: suspend IntegrationServiceEnvironmentSkuArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationServiceEnvironmentSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ifcthplaqiubhvwr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("seohcunvfovgvawj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentArgs = IntegrationServiceEnvironmentArgs(
        identity = identity,
        integrationServiceEnvironmentName = integrationServiceEnvironmentName,
        location = location,
        properties = properties,
        resourceGroup = resourceGroup,
        sku = sku,
        tags = tags,
    )
}
