@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement acknowledgement connection settings.
 * @property ignoreCertificateNameMismatch Indicates whether to ignore mismatch in certificate name.
 * @property keepHttpConnectionAlive Indicates whether to keep the connection alive.
 * @property supportHttpStatusCodeContinue Indicates whether to support HTTP status code 'CONTINUE'.
 * @property unfoldHttpHeaders Indicates whether to unfold the HTTP headers.
 */
public data class AS2AcknowledgementConnectionSettingsArgs(
    public val ignoreCertificateNameMismatch: Output<Boolean>,
    public val keepHttpConnectionAlive: Output<Boolean>,
    public val supportHttpStatusCodeContinue: Output<Boolean>,
    public val unfoldHttpHeaders: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs.builder()
            .ignoreCertificateNameMismatch(ignoreCertificateNameMismatch.applyValue({ args0 -> args0 }))
            .keepHttpConnectionAlive(keepHttpConnectionAlive.applyValue({ args0 -> args0 }))
            .supportHttpStatusCodeContinue(supportHttpStatusCodeContinue.applyValue({ args0 -> args0 }))
            .unfoldHttpHeaders(unfoldHttpHeaders.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2AcknowledgementConnectionSettingsArgs].
 */
@PulumiTagMarker
public class AS2AcknowledgementConnectionSettingsArgsBuilder internal constructor() {
    private var ignoreCertificateNameMismatch: Output<Boolean>? = null

    private var keepHttpConnectionAlive: Output<Boolean>? = null

    private var supportHttpStatusCodeContinue: Output<Boolean>? = null

    private var unfoldHttpHeaders: Output<Boolean>? = null

    /**
     * @param value Indicates whether to ignore mismatch in certificate name.
     */
    @JvmName("kduofqweuqddrdbg")
    public suspend fun ignoreCertificateNameMismatch(`value`: Output<Boolean>) {
        this.ignoreCertificateNameMismatch = value
    }

    /**
     * @param value Indicates whether to keep the connection alive.
     */
    @JvmName("hhylctyfljemlwxe")
    public suspend fun keepHttpConnectionAlive(`value`: Output<Boolean>) {
        this.keepHttpConnectionAlive = value
    }

    /**
     * @param value Indicates whether to support HTTP status code 'CONTINUE'.
     */
    @JvmName("cfbimovwakhdoyod")
    public suspend fun supportHttpStatusCodeContinue(`value`: Output<Boolean>) {
        this.supportHttpStatusCodeContinue = value
    }

    /**
     * @param value Indicates whether to unfold the HTTP headers.
     */
    @JvmName("vthsoyorunkdkosa")
    public suspend fun unfoldHttpHeaders(`value`: Output<Boolean>) {
        this.unfoldHttpHeaders = value
    }

    /**
     * @param value Indicates whether to ignore mismatch in certificate name.
     */
    @JvmName("mkodvqfltxfycdcj")
    public suspend fun ignoreCertificateNameMismatch(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreCertificateNameMismatch = mapped
    }

    /**
     * @param value Indicates whether to keep the connection alive.
     */
    @JvmName("msyalbjatsdiffha")
    public suspend fun keepHttpConnectionAlive(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keepHttpConnectionAlive = mapped
    }

    /**
     * @param value Indicates whether to support HTTP status code 'CONTINUE'.
     */
    @JvmName("ncqufrbdtalxuqyk")
    public suspend fun supportHttpStatusCodeContinue(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportHttpStatusCodeContinue = mapped
    }

    /**
     * @param value Indicates whether to unfold the HTTP headers.
     */
    @JvmName("egylrtxgegugdbxy")
    public suspend fun unfoldHttpHeaders(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unfoldHttpHeaders = mapped
    }

    internal fun build(): AS2AcknowledgementConnectionSettingsArgs =
        AS2AcknowledgementConnectionSettingsArgs(
            ignoreCertificateNameMismatch = ignoreCertificateNameMismatch ?: throw
                PulumiNullFieldException("ignoreCertificateNameMismatch"),
            keepHttpConnectionAlive = keepHttpConnectionAlive ?: throw
                PulumiNullFieldException("keepHttpConnectionAlive"),
            supportHttpStatusCodeContinue = supportHttpStatusCodeContinue ?: throw
                PulumiNullFieldException("supportHttpStatusCodeContinue"),
            unfoldHttpHeaders = unfoldHttpHeaders ?: throw PulumiNullFieldException("unfoldHttpHeaders"),
        )
}
