@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account AS2 one-way agreement.
 * @property protocolSettings The AS2 protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class AS2OneWayAgreementArgs(
    public val protocolSettings: Output<AS2ProtocolSettingsArgs>,
    public val receiverBusinessIdentity: Output<BusinessIdentityArgs>,
    public val senderBusinessIdentity: Output<BusinessIdentityArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs =
        com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs.builder()
            .protocolSettings(protocolSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .receiverBusinessIdentity(
                receiverBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .senderBusinessIdentity(
                senderBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AS2OneWayAgreementArgs].
 */
@PulumiTagMarker
public class AS2OneWayAgreementArgsBuilder internal constructor() {
    private var protocolSettings: Output<AS2ProtocolSettingsArgs>? = null

    private var receiverBusinessIdentity: Output<BusinessIdentityArgs>? = null

    private var senderBusinessIdentity: Output<BusinessIdentityArgs>? = null

    /**
     * @param value The AS2 protocol settings.
     */
    @JvmName("mgcxmlocbeumdnwl")
    public suspend fun protocolSettings(`value`: Output<AS2ProtocolSettingsArgs>) {
        this.protocolSettings = value
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("oqsbighbnnopnbcq")
    public suspend fun receiverBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.receiverBusinessIdentity = value
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("xuimiokjfxiaahkc")
    public suspend fun senderBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.senderBusinessIdentity = value
    }

    /**
     * @param value The AS2 protocol settings.
     */
    @JvmName("gbbuubcgrhdijgrt")
    public suspend fun protocolSettings(`value`: AS2ProtocolSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolSettings = mapped
    }

    /**
     * @param argument The AS2 protocol settings.
     */
    @JvmName("ocbiwegqwrjvigsl")
    public suspend fun protocolSettings(argument: suspend AS2ProtocolSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2ProtocolSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolSettings = mapped
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("uonixqtlitehedlk")
    public suspend fun receiverBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param argument The receiver business identity
     */
    @JvmName("vtfvyhbuioltiltw")
    public suspend
    fun receiverBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("rcwfbpihgnonuopu")
    public suspend fun senderBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.senderBusinessIdentity = mapped
    }

    /**
     * @param argument The sender business identity
     */
    @JvmName("chnojcbgukbqvjiw")
    public suspend
    fun senderBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.senderBusinessIdentity = mapped
    }

    internal fun build(): AS2OneWayAgreementArgs = AS2OneWayAgreementArgs(
        protocolSettings = protocolSettings ?: throw PulumiNullFieldException("protocolSettings"),
        receiverBusinessIdentity = receiverBusinessIdentity ?: throw
            PulumiNullFieldException("receiverBusinessIdentity"),
        senderBusinessIdentity = senderBusinessIdentity ?: throw
            PulumiNullFieldException("senderBusinessIdentity"),
    )
}
