@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AssemblyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The assembly properties definition.
 * @property assemblyCulture The assembly culture.
 * @property assemblyName The assembly name.
 * @property assemblyPublicKeyToken The assembly public key token.
 * @property assemblyVersion The assembly version.
 * @property changedTime The artifact changed time.
 * @property content
 * @property contentLink The content link.
 * @property contentType The content type.
 * @property createdTime The artifact creation time.
 * @property metadata
 */
public data class AssemblyPropertiesArgs(
    public val assemblyCulture: Output<String>? = null,
    public val assemblyName: Output<String>,
    public val assemblyPublicKeyToken: Output<String>? = null,
    public val assemblyVersion: Output<String>? = null,
    public val changedTime: Output<String>? = null,
    public val content: Output<Any>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val contentType: Output<String>? = null,
    public val createdTime: Output<String>? = null,
    public val metadata: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AssemblyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AssemblyPropertiesArgs =
        com.pulumi.azurenative.logic.inputs.AssemblyPropertiesArgs.builder()
            .assemblyCulture(assemblyCulture?.applyValue({ args0 -> args0 }))
            .assemblyName(assemblyName.applyValue({ args0 -> args0 }))
            .assemblyPublicKeyToken(assemblyPublicKeyToken?.applyValue({ args0 -> args0 }))
            .assemblyVersion(assemblyVersion?.applyValue({ args0 -> args0 }))
            .changedTime(changedTime?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .createdTime(createdTime?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssemblyPropertiesArgs].
 */
@PulumiTagMarker
public class AssemblyPropertiesArgsBuilder internal constructor() {
    private var assemblyCulture: Output<String>? = null

    private var assemblyName: Output<String>? = null

    private var assemblyPublicKeyToken: Output<String>? = null

    private var assemblyVersion: Output<String>? = null

    private var changedTime: Output<String>? = null

    private var content: Output<Any>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var contentType: Output<String>? = null

    private var createdTime: Output<String>? = null

    private var metadata: Output<Any>? = null

    /**
     * @param value The assembly culture.
     */
    @JvmName("xpqprxtqyqycgvby")
    public suspend fun assemblyCulture(`value`: Output<String>) {
        this.assemblyCulture = value
    }

    /**
     * @param value The assembly name.
     */
    @JvmName("hfwutbcfseqotcnv")
    public suspend fun assemblyName(`value`: Output<String>) {
        this.assemblyName = value
    }

    /**
     * @param value The assembly public key token.
     */
    @JvmName("mwfvcwbfxttjpaqm")
    public suspend fun assemblyPublicKeyToken(`value`: Output<String>) {
        this.assemblyPublicKeyToken = value
    }

    /**
     * @param value The assembly version.
     */
    @JvmName("seawdtpclreofwwy")
    public suspend fun assemblyVersion(`value`: Output<String>) {
        this.assemblyVersion = value
    }

    /**
     * @param value The artifact changed time.
     */
    @JvmName("ssybbfhwqlnbbsiw")
    public suspend fun changedTime(`value`: Output<String>) {
        this.changedTime = value
    }

    /**
     * @param value
     */
    @JvmName("ershustkcvqponla")
    public suspend fun content(`value`: Output<Any>) {
        this.content = value
    }

    /**
     * @param value The content link.
     */
    @JvmName("frpbergujutyucal")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value The content type.
     */
    @JvmName("wablcqhkphblnffo")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The artifact creation time.
     */
    @JvmName("loclgedvarhjfnbf")
    public suspend fun createdTime(`value`: Output<String>) {
        this.createdTime = value
    }

    /**
     * @param value
     */
    @JvmName("nmttrynivprqkxxw")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The assembly culture.
     */
    @JvmName("ijkukrrjqndwxewr")
    public suspend fun assemblyCulture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assemblyCulture = mapped
    }

    /**
     * @param value The assembly name.
     */
    @JvmName("wvpcgjswwueqlrds")
    public suspend fun assemblyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assemblyName = mapped
    }

    /**
     * @param value The assembly public key token.
     */
    @JvmName("xywpggppotdarrjc")
    public suspend fun assemblyPublicKeyToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assemblyPublicKeyToken = mapped
    }

    /**
     * @param value The assembly version.
     */
    @JvmName("gkrjgyttmdcascbr")
    public suspend fun assemblyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assemblyVersion = mapped
    }

    /**
     * @param value The artifact changed time.
     */
    @JvmName("lrubueyvqxdlrckh")
    public suspend fun changedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changedTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("vyyeledbydntoovm")
    public suspend fun content(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The content link.
     */
    @JvmName("pckpxseyjfprmkkp")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument The content link.
     */
    @JvmName("asieupnthrewdeyo")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value The content type.
     */
    @JvmName("movwxacgoimqumhb")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The artifact creation time.
     */
    @JvmName("yvxownxxbnosvalk")
    public suspend fun createdTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijxmbmdwftyvvomv")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    internal fun build(): AssemblyPropertiesArgs = AssemblyPropertiesArgs(
        assemblyCulture = assemblyCulture,
        assemblyName = assemblyName ?: throw PulumiNullFieldException("assemblyName"),
        assemblyPublicKeyToken = assemblyPublicKeyToken,
        assemblyVersion = assemblyVersion,
        changedTime = changedTime,
        content = content,
        contentLink = contentLink,
        contentType = contentType,
        createdTime = createdTime,
        metadata = metadata,
    )
}
