@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.B2BPartnerContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The B2B partner content.
 * @property businessIdentities The list of partner business identities.
 */
public data class B2BPartnerContentArgs(
    public val businessIdentities: Output<List<BusinessIdentityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.B2BPartnerContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.B2BPartnerContentArgs =
        com.pulumi.azurenative.logic.inputs.B2BPartnerContentArgs.builder()
            .businessIdentities(
                businessIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [B2BPartnerContentArgs].
 */
@PulumiTagMarker
public class B2BPartnerContentArgsBuilder internal constructor() {
    private var businessIdentities: Output<List<BusinessIdentityArgs>>? = null

    /**
     * @param value The list of partner business identities.
     */
    @JvmName("jloprufwjwnnmetr")
    public suspend fun businessIdentities(`value`: Output<List<BusinessIdentityArgs>>) {
        this.businessIdentities = value
    }

    @JvmName("jycbqscnahdctvjc")
    public suspend fun businessIdentities(vararg values: Output<BusinessIdentityArgs>) {
        this.businessIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of partner business identities.
     */
    @JvmName("jftlmsonekinsoyj")
    public suspend fun businessIdentities(values: List<Output<BusinessIdentityArgs>>) {
        this.businessIdentities = Output.all(values)
    }

    /**
     * @param value The list of partner business identities.
     */
    @JvmName("vmbpqjhmuffwapqh")
    public suspend fun businessIdentities(`value`: List<BusinessIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessIdentities = mapped
    }

    /**
     * @param argument The list of partner business identities.
     */
    @JvmName("dlwadlmxdfracokq")
    public suspend
    fun businessIdentities(argument: List<suspend BusinessIdentityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BusinessIdentityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.businessIdentities = mapped
    }

    /**
     * @param argument The list of partner business identities.
     */
    @JvmName("slxenicunigrlbya")
    public suspend fun businessIdentities(
        vararg
        argument: suspend BusinessIdentityArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BusinessIdentityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.businessIdentities = mapped
    }

    /**
     * @param argument The list of partner business identities.
     */
    @JvmName("dvyjhgyvsfmutuac")
    public suspend fun businessIdentities(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BusinessIdentityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.businessIdentities = mapped
    }

    /**
     * @param values The list of partner business identities.
     */
    @JvmName("lobqxwodugiebgip")
    public suspend fun businessIdentities(vararg values: BusinessIdentityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessIdentities = mapped
    }

    internal fun build(): B2BPartnerContentArgs = B2BPartnerContentArgs(
        businessIdentities = businessIdentities,
    )
}
