@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactAcknowledgementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact agreement acknowledgement settings.
 * @property acknowledgementControlNumberLowerBound The acknowledgement control number lower bound.
 * @property acknowledgementControlNumberPrefix The acknowledgement control number prefix.
 * @property acknowledgementControlNumberSuffix The acknowledgement control number suffix.
 * @property acknowledgementControlNumberUpperBound The acknowledgement control number upper bound.
 * @property batchFunctionalAcknowledgements The value indicating whether to batch functional acknowledgements.
 * @property batchTechnicalAcknowledgements The value indicating whether to batch the technical acknowledgements.
 * @property needFunctionalAcknowledgement The value indicating whether functional acknowledgement is needed.
 * @property needLoopForValidMessages The value indicating whether a loop is needed for valid messages.
 * @property needTechnicalAcknowledgement The value indicating whether technical acknowledgement is needed.
 * @property rolloverAcknowledgementControlNumber The value indicating whether to rollover acknowledgement control number.
 * @property sendSynchronousAcknowledgement The value indicating whether to send synchronous acknowledgement.
 */
public data class EdifactAcknowledgementSettingsArgs(
    public val acknowledgementControlNumberLowerBound: Output<Int>,
    public val acknowledgementControlNumberPrefix: Output<String>? = null,
    public val acknowledgementControlNumberSuffix: Output<String>? = null,
    public val acknowledgementControlNumberUpperBound: Output<Int>,
    public val batchFunctionalAcknowledgements: Output<Boolean>,
    public val batchTechnicalAcknowledgements: Output<Boolean>,
    public val needFunctionalAcknowledgement: Output<Boolean>,
    public val needLoopForValidMessages: Output<Boolean>,
    public val needTechnicalAcknowledgement: Output<Boolean>,
    public val rolloverAcknowledgementControlNumber: Output<Boolean>,
    public val sendSynchronousAcknowledgement: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactAcknowledgementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactAcknowledgementSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactAcknowledgementSettingsArgs.builder()
            .acknowledgementControlNumberLowerBound(
                acknowledgementControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberPrefix(
                acknowledgementControlNumberPrefix?.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberSuffix(
                acknowledgementControlNumberSuffix?.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberUpperBound(
                acknowledgementControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            )
            .batchFunctionalAcknowledgements(batchFunctionalAcknowledgements.applyValue({ args0 -> args0 }))
            .batchTechnicalAcknowledgements(batchTechnicalAcknowledgements.applyValue({ args0 -> args0 }))
            .needFunctionalAcknowledgement(needFunctionalAcknowledgement.applyValue({ args0 -> args0 }))
            .needLoopForValidMessages(needLoopForValidMessages.applyValue({ args0 -> args0 }))
            .needTechnicalAcknowledgement(needTechnicalAcknowledgement.applyValue({ args0 -> args0 }))
            .rolloverAcknowledgementControlNumber(
                rolloverAcknowledgementControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .sendSynchronousAcknowledgement(
                sendSynchronousAcknowledgement.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EdifactAcknowledgementSettingsArgs].
 */
@PulumiTagMarker
public class EdifactAcknowledgementSettingsArgsBuilder internal constructor() {
    private var acknowledgementControlNumberLowerBound: Output<Int>? = null

    private var acknowledgementControlNumberPrefix: Output<String>? = null

    private var acknowledgementControlNumberSuffix: Output<String>? = null

    private var acknowledgementControlNumberUpperBound: Output<Int>? = null

    private var batchFunctionalAcknowledgements: Output<Boolean>? = null

    private var batchTechnicalAcknowledgements: Output<Boolean>? = null

    private var needFunctionalAcknowledgement: Output<Boolean>? = null

    private var needLoopForValidMessages: Output<Boolean>? = null

    private var needTechnicalAcknowledgement: Output<Boolean>? = null

    private var rolloverAcknowledgementControlNumber: Output<Boolean>? = null

    private var sendSynchronousAcknowledgement: Output<Boolean>? = null

    /**
     * @param value The acknowledgement control number lower bound.
     */
    @JvmName("npgvplseilyaprwe")
    public suspend fun acknowledgementControlNumberLowerBound(`value`: Output<Int>) {
        this.acknowledgementControlNumberLowerBound = value
    }

    /**
     * @param value The acknowledgement control number prefix.
     */
    @JvmName("ainxucynhkunwoqq")
    public suspend fun acknowledgementControlNumberPrefix(`value`: Output<String>) {
        this.acknowledgementControlNumberPrefix = value
    }

    /**
     * @param value The acknowledgement control number suffix.
     */
    @JvmName("qjhwptngxjakrffg")
    public suspend fun acknowledgementControlNumberSuffix(`value`: Output<String>) {
        this.acknowledgementControlNumberSuffix = value
    }

    /**
     * @param value The acknowledgement control number upper bound.
     */
    @JvmName("itlgrsyckxshtcid")
    public suspend fun acknowledgementControlNumberUpperBound(`value`: Output<Int>) {
        this.acknowledgementControlNumberUpperBound = value
    }

    /**
     * @param value The value indicating whether to batch functional acknowledgements.
     */
    @JvmName("jdtgwblnstopaouy")
    public suspend fun batchFunctionalAcknowledgements(`value`: Output<Boolean>) {
        this.batchFunctionalAcknowledgements = value
    }

    /**
     * @param value The value indicating whether to batch the technical acknowledgements.
     */
    @JvmName("uunrnquxpxwosydq")
    public suspend fun batchTechnicalAcknowledgements(`value`: Output<Boolean>) {
        this.batchTechnicalAcknowledgements = value
    }

    /**
     * @param value The value indicating whether functional acknowledgement is needed.
     */
    @JvmName("irqodkuupmexqhsb")
    public suspend fun needFunctionalAcknowledgement(`value`: Output<Boolean>) {
        this.needFunctionalAcknowledgement = value
    }

    /**
     * @param value The value indicating whether a loop is needed for valid messages.
     */
    @JvmName("fqonuwvynsfmrtgf")
    public suspend fun needLoopForValidMessages(`value`: Output<Boolean>) {
        this.needLoopForValidMessages = value
    }

    /**
     * @param value The value indicating whether technical acknowledgement is needed.
     */
    @JvmName("hnhwrklijvkstmdd")
    public suspend fun needTechnicalAcknowledgement(`value`: Output<Boolean>) {
        this.needTechnicalAcknowledgement = value
    }

    /**
     * @param value The value indicating whether to rollover acknowledgement control number.
     */
    @JvmName("eysdnlkgafbuvxke")
    public suspend fun rolloverAcknowledgementControlNumber(`value`: Output<Boolean>) {
        this.rolloverAcknowledgementControlNumber = value
    }

    /**
     * @param value The value indicating whether to send synchronous acknowledgement.
     */
    @JvmName("hqgpsyqdsdnccsai")
    public suspend fun sendSynchronousAcknowledgement(`value`: Output<Boolean>) {
        this.sendSynchronousAcknowledgement = value
    }

    /**
     * @param value The acknowledgement control number lower bound.
     */
    @JvmName("hbgmwqmrahfxmljc")
    public suspend fun acknowledgementControlNumberLowerBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberLowerBound = mapped
    }

    /**
     * @param value The acknowledgement control number prefix.
     */
    @JvmName("exserdpymkhqoyon")
    public suspend fun acknowledgementControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberPrefix = mapped
    }

    /**
     * @param value The acknowledgement control number suffix.
     */
    @JvmName("avdfjnrdvmovicch")
    public suspend fun acknowledgementControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberSuffix = mapped
    }

    /**
     * @param value The acknowledgement control number upper bound.
     */
    @JvmName("bslsibjdrqamfqgq")
    public suspend fun acknowledgementControlNumberUpperBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberUpperBound = mapped
    }

    /**
     * @param value The value indicating whether to batch functional acknowledgements.
     */
    @JvmName("blejyiaqkrfpqpig")
    public suspend fun batchFunctionalAcknowledgements(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchFunctionalAcknowledgements = mapped
    }

    /**
     * @param value The value indicating whether to batch the technical acknowledgements.
     */
    @JvmName("uikomaygehaixtyv")
    public suspend fun batchTechnicalAcknowledgements(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchTechnicalAcknowledgements = mapped
    }

    /**
     * @param value The value indicating whether functional acknowledgement is needed.
     */
    @JvmName("tvtqhgkeqwgdfouu")
    public suspend fun needFunctionalAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needFunctionalAcknowledgement = mapped
    }

    /**
     * @param value The value indicating whether a loop is needed for valid messages.
     */
    @JvmName("xxcjdhgebmkmoyqh")
    public suspend fun needLoopForValidMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needLoopForValidMessages = mapped
    }

    /**
     * @param value The value indicating whether technical acknowledgement is needed.
     */
    @JvmName("ruofuxwifeqncduj")
    public suspend fun needTechnicalAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needTechnicalAcknowledgement = mapped
    }

    /**
     * @param value The value indicating whether to rollover acknowledgement control number.
     */
    @JvmName("eursdqjpmnbrcmoa")
    public suspend fun rolloverAcknowledgementControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverAcknowledgementControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to send synchronous acknowledgement.
     */
    @JvmName("jcebqhnxvmgliehi")
    public suspend fun sendSynchronousAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendSynchronousAcknowledgement = mapped
    }

    internal fun build(): EdifactAcknowledgementSettingsArgs = EdifactAcknowledgementSettingsArgs(
        acknowledgementControlNumberLowerBound = acknowledgementControlNumberLowerBound ?: throw
            PulumiNullFieldException("acknowledgementControlNumberLowerBound"),
        acknowledgementControlNumberPrefix = acknowledgementControlNumberPrefix,
        acknowledgementControlNumberSuffix = acknowledgementControlNumberSuffix,
        acknowledgementControlNumberUpperBound = acknowledgementControlNumberUpperBound ?: throw
            PulumiNullFieldException("acknowledgementControlNumberUpperBound"),
        batchFunctionalAcknowledgements = batchFunctionalAcknowledgements ?: throw
            PulumiNullFieldException("batchFunctionalAcknowledgements"),
        batchTechnicalAcknowledgements = batchTechnicalAcknowledgements ?: throw
            PulumiNullFieldException("batchTechnicalAcknowledgements"),
        needFunctionalAcknowledgement = needFunctionalAcknowledgement ?: throw
            PulumiNullFieldException("needFunctionalAcknowledgement"),
        needLoopForValidMessages = needLoopForValidMessages ?: throw
            PulumiNullFieldException("needLoopForValidMessages"),
        needTechnicalAcknowledgement = needTechnicalAcknowledgement ?: throw
            PulumiNullFieldException("needTechnicalAcknowledgement"),
        rolloverAcknowledgementControlNumber = rolloverAcknowledgementControlNumber ?: throw
            PulumiNullFieldException("rolloverAcknowledgementControlNumber"),
        sendSynchronousAcknowledgement = sendSynchronousAcknowledgement ?: throw
            PulumiNullFieldException("sendSynchronousAcknowledgement"),
    )
}
