@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactDelimiterOverrideArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.EdifactDecimalIndicator
import com.pulumi.azurenative.logic.kotlin.enums.SegmentTerminatorSuffix
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact delimiter override settings.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property decimalPointIndicator The decimal point indicator.
 * @property messageAssociationAssignedCode The message association assigned code.
 * @property messageId The message id.
 * @property messageRelease The message release.
 * @property messageVersion The message version.
 * @property releaseIndicator The release indicator.
 * @property repetitionSeparator The repetition separator.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 * @property targetNamespace The target namespace on which this delimiter settings has to be applied.
 */
public data class EdifactDelimiterOverrideArgs(
    public val componentSeparator: Output<Int>,
    public val dataElementSeparator: Output<Int>,
    public val decimalPointIndicator: Output<EdifactDecimalIndicator>,
    public val messageAssociationAssignedCode: Output<String>? = null,
    public val messageId: Output<String>? = null,
    public val messageRelease: Output<String>? = null,
    public val messageVersion: Output<String>? = null,
    public val releaseIndicator: Output<Int>,
    public val repetitionSeparator: Output<Int>,
    public val segmentTerminator: Output<Int>,
    public val segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>,
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactDelimiterOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactDelimiterOverrideArgs =
        com.pulumi.azurenative.logic.inputs.EdifactDelimiterOverrideArgs.builder()
            .componentSeparator(componentSeparator.applyValue({ args0 -> args0 }))
            .dataElementSeparator(dataElementSeparator.applyValue({ args0 -> args0 }))
            .decimalPointIndicator(
                decimalPointIndicator.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .messageAssociationAssignedCode(messageAssociationAssignedCode?.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .messageRelease(messageRelease?.applyValue({ args0 -> args0 }))
            .messageVersion(messageVersion?.applyValue({ args0 -> args0 }))
            .releaseIndicator(releaseIndicator.applyValue({ args0 -> args0 }))
            .repetitionSeparator(repetitionSeparator.applyValue({ args0 -> args0 }))
            .segmentTerminator(segmentTerminator.applyValue({ args0 -> args0 }))
            .segmentTerminatorSuffix(
                segmentTerminatorSuffix.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactDelimiterOverrideArgs].
 */
@PulumiTagMarker
public class EdifactDelimiterOverrideArgsBuilder internal constructor() {
    private var componentSeparator: Output<Int>? = null

    private var dataElementSeparator: Output<Int>? = null

    private var decimalPointIndicator: Output<EdifactDecimalIndicator>? = null

    private var messageAssociationAssignedCode: Output<String>? = null

    private var messageId: Output<String>? = null

    private var messageRelease: Output<String>? = null

    private var messageVersion: Output<String>? = null

    private var releaseIndicator: Output<Int>? = null

    private var repetitionSeparator: Output<Int>? = null

    private var segmentTerminator: Output<Int>? = null

    private var segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>? = null

    private var targetNamespace: Output<String>? = null

    /**
     * @param value The component separator.
     */
    @JvmName("gwgilwsrllykipgd")
    public suspend fun componentSeparator(`value`: Output<Int>) {
        this.componentSeparator = value
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("ktdqyohdhloymaxi")
    public suspend fun dataElementSeparator(`value`: Output<Int>) {
        this.dataElementSeparator = value
    }

    /**
     * @param value The decimal point indicator.
     */
    @JvmName("hikoxwqvbcsjcqqm")
    public suspend fun decimalPointIndicator(`value`: Output<EdifactDecimalIndicator>) {
        this.decimalPointIndicator = value
    }

    /**
     * @param value The message association assigned code.
     */
    @JvmName("lonqucfoprrworbd")
    public suspend fun messageAssociationAssignedCode(`value`: Output<String>) {
        this.messageAssociationAssignedCode = value
    }

    /**
     * @param value The message id.
     */
    @JvmName("ntlobpttoewufcrd")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The message release.
     */
    @JvmName("owaebtkolxuvygfj")
    public suspend fun messageRelease(`value`: Output<String>) {
        this.messageRelease = value
    }

    /**
     * @param value The message version.
     */
    @JvmName("asuqulbrhlbliayq")
    public suspend fun messageVersion(`value`: Output<String>) {
        this.messageVersion = value
    }

    /**
     * @param value The release indicator.
     */
    @JvmName("atxbsckovfkcpgtm")
    public suspend fun releaseIndicator(`value`: Output<Int>) {
        this.releaseIndicator = value
    }

    /**
     * @param value The repetition separator.
     */
    @JvmName("cymddlicmwphrmku")
    public suspend fun repetitionSeparator(`value`: Output<Int>) {
        this.repetitionSeparator = value
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("btbigygwfepisodq")
    public suspend fun segmentTerminator(`value`: Output<Int>) {
        this.segmentTerminator = value
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("cvyhlekawpojpkpx")
    public suspend fun segmentTerminatorSuffix(`value`: Output<SegmentTerminatorSuffix>) {
        this.segmentTerminatorSuffix = value
    }

    /**
     * @param value The target namespace on which this delimiter settings has to be applied.
     */
    @JvmName("dbmpfrkwhxndrkef")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The component separator.
     */
    @JvmName("wwndilbxrlgfjjcm")
    public suspend fun componentSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentSeparator = mapped
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("uykjlvysmdhwvjia")
    public suspend fun dataElementSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataElementSeparator = mapped
    }

    /**
     * @param value The decimal point indicator.
     */
    @JvmName("uicnunbgvsrvcqbh")
    public suspend fun decimalPointIndicator(`value`: EdifactDecimalIndicator) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decimalPointIndicator = mapped
    }

    /**
     * @param value The message association assigned code.
     */
    @JvmName("ngrbljhbookjxbva")
    public suspend fun messageAssociationAssignedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageAssociationAssignedCode = mapped
    }

    /**
     * @param value The message id.
     */
    @JvmName("cxduqlrmstmyrcmh")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The message release.
     */
    @JvmName("rbwwplaqxhnxywvb")
    public suspend fun messageRelease(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRelease = mapped
    }

    /**
     * @param value The message version.
     */
    @JvmName("maxtgieomsrtfyod")
    public suspend fun messageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageVersion = mapped
    }

    /**
     * @param value The release indicator.
     */
    @JvmName("nauklpmaribojmar")
    public suspend fun releaseIndicator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.releaseIndicator = mapped
    }

    /**
     * @param value The repetition separator.
     */
    @JvmName("xekqlqudrwwjhwtb")
    public suspend fun repetitionSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repetitionSeparator = mapped
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("cgelyrkrlrmgaxuf")
    public suspend fun segmentTerminator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminator = mapped
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("vucovmwqsahpinys")
    public suspend fun segmentTerminatorSuffix(`value`: SegmentTerminatorSuffix) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminatorSuffix = mapped
    }

    /**
     * @param value The target namespace on which this delimiter settings has to be applied.
     */
    @JvmName("nbffttqanwmrmqym")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): EdifactDelimiterOverrideArgs = EdifactDelimiterOverrideArgs(
        componentSeparator = componentSeparator ?: throw PulumiNullFieldException("componentSeparator"),
        dataElementSeparator = dataElementSeparator ?: throw
            PulumiNullFieldException("dataElementSeparator"),
        decimalPointIndicator = decimalPointIndicator ?: throw
            PulumiNullFieldException("decimalPointIndicator"),
        messageAssociationAssignedCode = messageAssociationAssignedCode,
        messageId = messageId,
        messageRelease = messageRelease,
        messageVersion = messageVersion,
        releaseIndicator = releaseIndicator ?: throw PulumiNullFieldException("releaseIndicator"),
        repetitionSeparator = repetitionSeparator ?: throw PulumiNullFieldException("repetitionSeparator"),
        segmentTerminator = segmentTerminator ?: throw PulumiNullFieldException("segmentTerminator"),
        segmentTerminatorSuffix = segmentTerminatorSuffix ?: throw
            PulumiNullFieldException("segmentTerminatorSuffix"),
        targetNamespace = targetNamespace,
    )
}
