@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Edifact agreement protocol settings.
 * @property acknowledgementSettings The EDIFACT acknowledgement settings.
 * @property edifactDelimiterOverrides The EDIFACT delimiter override settings.
 * @property envelopeOverrides The EDIFACT envelope override settings.
 * @property envelopeSettings The EDIFACT envelope settings.
 * @property framingSettings The EDIFACT framing settings.
 * @property messageFilter The EDIFACT message filter.
 * @property messageFilterList The EDIFACT message filter list.
 * @property processingSettings The EDIFACT processing Settings.
 * @property schemaReferences The EDIFACT schema references.
 * @property validationOverrides The EDIFACT validation override settings.
 * @property validationSettings The EDIFACT validation settings.
 */
public data class EdifactProtocolSettingsArgs(
    public val acknowledgementSettings: Output<EdifactAcknowledgementSettingsArgs>,
    public val edifactDelimiterOverrides: Output<List<EdifactDelimiterOverrideArgs>>? = null,
    public val envelopeOverrides: Output<List<EdifactEnvelopeOverrideArgs>>? = null,
    public val envelopeSettings: Output<EdifactEnvelopeSettingsArgs>,
    public val framingSettings: Output<EdifactFramingSettingsArgs>,
    public val messageFilter: Output<EdifactMessageFilterArgs>,
    public val messageFilterList: Output<List<EdifactMessageIdentifierArgs>>? = null,
    public val processingSettings: Output<EdifactProcessingSettingsArgs>,
    public val schemaReferences: Output<List<EdifactSchemaReferenceArgs>>,
    public val validationOverrides: Output<List<EdifactValidationOverrideArgs>>? = null,
    public val validationSettings: Output<EdifactValidationSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs.builder()
            .acknowledgementSettings(
                acknowledgementSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .edifactDelimiterOverrides(
                edifactDelimiterOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .envelopeOverrides(
                envelopeOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .envelopeSettings(envelopeSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .framingSettings(framingSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilter(messageFilter.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilterList(
                messageFilterList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processingSettings(
                processingSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaReferences(
                schemaReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .validationOverrides(
                validationOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .validationSettings(
                validationSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EdifactProtocolSettingsArgs].
 */
@PulumiTagMarker
public class EdifactProtocolSettingsArgsBuilder internal constructor() {
    private var acknowledgementSettings: Output<EdifactAcknowledgementSettingsArgs>? = null

    private var edifactDelimiterOverrides: Output<List<EdifactDelimiterOverrideArgs>>? = null

    private var envelopeOverrides: Output<List<EdifactEnvelopeOverrideArgs>>? = null

    private var envelopeSettings: Output<EdifactEnvelopeSettingsArgs>? = null

    private var framingSettings: Output<EdifactFramingSettingsArgs>? = null

    private var messageFilter: Output<EdifactMessageFilterArgs>? = null

    private var messageFilterList: Output<List<EdifactMessageIdentifierArgs>>? = null

    private var processingSettings: Output<EdifactProcessingSettingsArgs>? = null

    private var schemaReferences: Output<List<EdifactSchemaReferenceArgs>>? = null

    private var validationOverrides: Output<List<EdifactValidationOverrideArgs>>? = null

    private var validationSettings: Output<EdifactValidationSettingsArgs>? = null

    /**
     * @param value The EDIFACT acknowledgement settings.
     */
    @JvmName("esmagaepkadevlcu")
    public suspend fun acknowledgementSettings(`value`: Output<EdifactAcknowledgementSettingsArgs>) {
        this.acknowledgementSettings = value
    }

    /**
     * @param value The EDIFACT delimiter override settings.
     */
    @JvmName("yaeiesstqfugvwhs")
    public suspend
    fun edifactDelimiterOverrides(`value`: Output<List<EdifactDelimiterOverrideArgs>>) {
        this.edifactDelimiterOverrides = value
    }

    @JvmName("qmpwwthmbpurwqmu")
    public suspend fun edifactDelimiterOverrides(
        vararg
        values: Output<EdifactDelimiterOverrideArgs>,
    ) {
        this.edifactDelimiterOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT delimiter override settings.
     */
    @JvmName("pyintgctnaiyfrbv")
    public suspend fun edifactDelimiterOverrides(values: List<Output<EdifactDelimiterOverrideArgs>>) {
        this.edifactDelimiterOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT envelope override settings.
     */
    @JvmName("neyrxhqkfmgqmmkb")
    public suspend fun envelopeOverrides(`value`: Output<List<EdifactEnvelopeOverrideArgs>>) {
        this.envelopeOverrides = value
    }

    @JvmName("xyquvdgundrytyvm")
    public suspend fun envelopeOverrides(vararg values: Output<EdifactEnvelopeOverrideArgs>) {
        this.envelopeOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT envelope override settings.
     */
    @JvmName("crnskqrcodpjvdov")
    public suspend fun envelopeOverrides(values: List<Output<EdifactEnvelopeOverrideArgs>>) {
        this.envelopeOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT envelope settings.
     */
    @JvmName("dvxgtpsmhjelttwo")
    public suspend fun envelopeSettings(`value`: Output<EdifactEnvelopeSettingsArgs>) {
        this.envelopeSettings = value
    }

    /**
     * @param value The EDIFACT framing settings.
     */
    @JvmName("tlgsewksywqedfua")
    public suspend fun framingSettings(`value`: Output<EdifactFramingSettingsArgs>) {
        this.framingSettings = value
    }

    /**
     * @param value The EDIFACT message filter.
     */
    @JvmName("eiigvintdfmuirrl")
    public suspend fun messageFilter(`value`: Output<EdifactMessageFilterArgs>) {
        this.messageFilter = value
    }

    /**
     * @param value The EDIFACT message filter list.
     */
    @JvmName("stubginswjrgbpwt")
    public suspend fun messageFilterList(`value`: Output<List<EdifactMessageIdentifierArgs>>) {
        this.messageFilterList = value
    }

    @JvmName("frjbxdfslkdytouf")
    public suspend fun messageFilterList(vararg values: Output<EdifactMessageIdentifierArgs>) {
        this.messageFilterList = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT message filter list.
     */
    @JvmName("oevoddqfxcnlptet")
    public suspend fun messageFilterList(values: List<Output<EdifactMessageIdentifierArgs>>) {
        this.messageFilterList = Output.all(values)
    }

    /**
     * @param value The EDIFACT processing Settings.
     */
    @JvmName("artkyuaujtpxgknc")
    public suspend fun processingSettings(`value`: Output<EdifactProcessingSettingsArgs>) {
        this.processingSettings = value
    }

    /**
     * @param value The EDIFACT schema references.
     */
    @JvmName("etqojrxhhbjqhynb")
    public suspend fun schemaReferences(`value`: Output<List<EdifactSchemaReferenceArgs>>) {
        this.schemaReferences = value
    }

    @JvmName("dgdtrnwpucdoekkp")
    public suspend fun schemaReferences(vararg values: Output<EdifactSchemaReferenceArgs>) {
        this.schemaReferences = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT schema references.
     */
    @JvmName("ahllbackoqdllnvm")
    public suspend fun schemaReferences(values: List<Output<EdifactSchemaReferenceArgs>>) {
        this.schemaReferences = Output.all(values)
    }

    /**
     * @param value The EDIFACT validation override settings.
     */
    @JvmName("wsxuovnrtltfxumm")
    public suspend fun validationOverrides(`value`: Output<List<EdifactValidationOverrideArgs>>) {
        this.validationOverrides = value
    }

    @JvmName("lhhxgceptqbjcxda")
    public suspend fun validationOverrides(vararg values: Output<EdifactValidationOverrideArgs>) {
        this.validationOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT validation override settings.
     */
    @JvmName("ygbgdiisukykbqan")
    public suspend fun validationOverrides(values: List<Output<EdifactValidationOverrideArgs>>) {
        this.validationOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT validation settings.
     */
    @JvmName("hipsoiptfimrxotc")
    public suspend fun validationSettings(`value`: Output<EdifactValidationSettingsArgs>) {
        this.validationSettings = value
    }

    /**
     * @param value The EDIFACT acknowledgement settings.
     */
    @JvmName("fvorxhoxqrkyksui")
    public suspend fun acknowledgementSettings(`value`: EdifactAcknowledgementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementSettings = mapped
    }

    /**
     * @param argument The EDIFACT acknowledgement settings.
     */
    @JvmName("sctpqterjrglsekb")
    public suspend
    fun acknowledgementSettings(argument: suspend EdifactAcknowledgementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactAcknowledgementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.acknowledgementSettings = mapped
    }

    /**
     * @param value The EDIFACT delimiter override settings.
     */
    @JvmName("yutfmecymuttsgxs")
    public suspend fun edifactDelimiterOverrides(`value`: List<EdifactDelimiterOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("eoxncvnrmmqpflxd")
    public suspend
    fun edifactDelimiterOverrides(argument: List<suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("kxcfiwifongieosr")
    public suspend fun edifactDelimiterOverrides(
        vararg
        argument: suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("hojcyyuclxwrpilm")
    public suspend
    fun edifactDelimiterOverrides(argument: suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param values The EDIFACT delimiter override settings.
     */
    @JvmName("smiifaegpxwntbid")
    public suspend fun edifactDelimiterOverrides(vararg values: EdifactDelimiterOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param value The EDIFACT envelope override settings.
     */
    @JvmName("gtbttcrwswotksml")
    public suspend fun envelopeOverrides(`value`: List<EdifactEnvelopeOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("uuuhaybcrijltllp")
    public suspend
    fun envelopeOverrides(argument: List<suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("tdwhjougorhfpkxh")
    public suspend fun envelopeOverrides(
        vararg
        argument: suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("wcdirnjjwgbrhabl")
    public suspend
    fun envelopeOverrides(argument: suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param values The EDIFACT envelope override settings.
     */
    @JvmName("jospsxioyaafyuhu")
    public suspend fun envelopeOverrides(vararg values: EdifactEnvelopeOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param value The EDIFACT envelope settings.
     */
    @JvmName("epaspvtnamoxssyr")
    public suspend fun envelopeSettings(`value`: EdifactEnvelopeSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeSettings = mapped
    }

    /**
     * @param argument The EDIFACT envelope settings.
     */
    @JvmName("aarfnjnbjatlascw")
    public suspend
    fun envelopeSettings(argument: suspend EdifactEnvelopeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactEnvelopeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envelopeSettings = mapped
    }

    /**
     * @param value The EDIFACT framing settings.
     */
    @JvmName("fgifjnumiwmythhw")
    public suspend fun framingSettings(`value`: EdifactFramingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.framingSettings = mapped
    }

    /**
     * @param argument The EDIFACT framing settings.
     */
    @JvmName("asjhqdbhgpeanolf")
    public suspend
    fun framingSettings(argument: suspend EdifactFramingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactFramingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.framingSettings = mapped
    }

    /**
     * @param value The EDIFACT message filter.
     */
    @JvmName("sfnkmiuivyyhllna")
    public suspend fun messageFilter(`value`: EdifactMessageFilterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilter = mapped
    }

    /**
     * @param argument The EDIFACT message filter.
     */
    @JvmName("ivnfwejypevdjojt")
    public suspend fun messageFilter(argument: suspend EdifactMessageFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactMessageFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.messageFilter = mapped
    }

    /**
     * @param value The EDIFACT message filter list.
     */
    @JvmName("kpfrwekqlalpghyq")
    public suspend fun messageFilterList(`value`: List<EdifactMessageIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("uyvamlfbltbuheuv")
    public suspend
    fun messageFilterList(argument: List<suspend EdifactMessageIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("uiygrknrahlqilgq")
    public suspend fun messageFilterList(
        vararg
        argument: suspend EdifactMessageIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("eytnboormdwtvuqe")
    public suspend
    fun messageFilterList(argument: suspend EdifactMessageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param values The EDIFACT message filter list.
     */
    @JvmName("mwbkgbagkysxxral")
    public suspend fun messageFilterList(vararg values: EdifactMessageIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param value The EDIFACT processing Settings.
     */
    @JvmName("bxdvnyqyvmrkdlwf")
    public suspend fun processingSettings(`value`: EdifactProcessingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processingSettings = mapped
    }

    /**
     * @param argument The EDIFACT processing Settings.
     */
    @JvmName("xkuiykcyvpsptspr")
    public suspend
    fun processingSettings(argument: suspend EdifactProcessingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactProcessingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.processingSettings = mapped
    }

    /**
     * @param value The EDIFACT schema references.
     */
    @JvmName("abnxknorixbfhmbu")
    public suspend fun schemaReferences(`value`: List<EdifactSchemaReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("dglgrrflgwvivqsa")
    public suspend
    fun schemaReferences(argument: List<suspend EdifactSchemaReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactSchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("baavihjmjtvfwxnu")
    public suspend fun schemaReferences(
        vararg
        argument: suspend EdifactSchemaReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactSchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("jusgcniqgyxjivfr")
    public suspend
    fun schemaReferences(argument: suspend EdifactSchemaReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EdifactSchemaReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param values The EDIFACT schema references.
     */
    @JvmName("taskfgpnwmsdlwrr")
    public suspend fun schemaReferences(vararg values: EdifactSchemaReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param value The EDIFACT validation override settings.
     */
    @JvmName("pornwapgtrmwxwmt")
    public suspend fun validationOverrides(`value`: List<EdifactValidationOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("pbdgraqfhtxkvqqb")
    public suspend
    fun validationOverrides(argument: List<suspend EdifactValidationOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("yikmsbbrytjaevbv")
    public suspend fun validationOverrides(
        vararg
        argument: suspend EdifactValidationOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("qqbambblbirnapfp")
    public suspend
    fun validationOverrides(argument: suspend EdifactValidationOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactValidationOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param values The EDIFACT validation override settings.
     */
    @JvmName("vnbiixeeywgnlfvy")
    public suspend fun validationOverrides(vararg values: EdifactValidationOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param value The EDIFACT validation settings.
     */
    @JvmName("tvmrfalvyfvvivit")
    public suspend fun validationSettings(`value`: EdifactValidationSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationSettings = mapped
    }

    /**
     * @param argument The EDIFACT validation settings.
     */
    @JvmName("nqhfvcdjnpuaipvw")
    public suspend
    fun validationSettings(argument: suspend EdifactValidationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactValidationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationSettings = mapped
    }

    internal fun build(): EdifactProtocolSettingsArgs = EdifactProtocolSettingsArgs(
        acknowledgementSettings = acknowledgementSettings ?: throw
            PulumiNullFieldException("acknowledgementSettings"),
        edifactDelimiterOverrides = edifactDelimiterOverrides,
        envelopeOverrides = envelopeOverrides,
        envelopeSettings = envelopeSettings ?: throw PulumiNullFieldException("envelopeSettings"),
        framingSettings = framingSettings ?: throw PulumiNullFieldException("framingSettings"),
        messageFilter = messageFilter ?: throw PulumiNullFieldException("messageFilter"),
        messageFilterList = messageFilterList,
        processingSettings = processingSettings ?: throw PulumiNullFieldException("processingSettings"),
        schemaReferences = schemaReferences ?: throw PulumiNullFieldException("schemaReferences"),
        validationOverrides = validationOverrides,
        validationSettings = validationSettings ?: throw PulumiNullFieldException("validationSettings"),
    )
}
