@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactValidationSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.TrailingSeparatorPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact agreement validation settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property checkDuplicateGroupControlNumber The value indicating whether to check for duplicate group control number.
 * @property checkDuplicateInterchangeControlNumber The value indicating whether to check for duplicate interchange control number.
 * @property checkDuplicateTransactionSetControlNumber The value indicating whether to check for duplicate transaction set control number.
 * @property interchangeControlNumberValidityDays The validity period of interchange control number.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateCharacterSet The value indicating whether to validate character set in the message.
 * @property validateEDITypes The value indicating whether to Whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to Whether to validate XSD types.
 */
public data class EdifactValidationSettingsArgs(
    public val allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val checkDuplicateGroupControlNumber: Output<Boolean>,
    public val checkDuplicateInterchangeControlNumber: Output<Boolean>,
    public val checkDuplicateTransactionSetControlNumber: Output<Boolean>,
    public val interchangeControlNumberValidityDays: Output<Int>,
    public val trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>,
    public val trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val validateCharacterSet: Output<Boolean>,
    public val validateEDITypes: Output<Boolean>,
    public val validateXSDTypes: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactValidationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactValidationSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactValidationSettingsArgs.builder()
            .allowLeadingAndTrailingSpacesAndZeroes(
                allowLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .checkDuplicateGroupControlNumber(checkDuplicateGroupControlNumber.applyValue({ args0 -> args0 }))
            .checkDuplicateInterchangeControlNumber(
                checkDuplicateInterchangeControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .checkDuplicateTransactionSetControlNumber(
                checkDuplicateTransactionSetControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .interchangeControlNumberValidityDays(
                interchangeControlNumberValidityDays.applyValue({ args0 ->
                    args0
                }),
            )
            .trailingSeparatorPolicy(
                trailingSeparatorPolicy.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .trimLeadingAndTrailingSpacesAndZeroes(
                trimLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .validateCharacterSet(validateCharacterSet.applyValue({ args0 -> args0 }))
            .validateEDITypes(validateEDITypes.applyValue({ args0 -> args0 }))
            .validateXSDTypes(validateXSDTypes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactValidationSettingsArgs].
 */
@PulumiTagMarker
public class EdifactValidationSettingsArgsBuilder internal constructor() {
    private var allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var checkDuplicateGroupControlNumber: Output<Boolean>? = null

    private var checkDuplicateInterchangeControlNumber: Output<Boolean>? = null

    private var checkDuplicateTransactionSetControlNumber: Output<Boolean>? = null

    private var interchangeControlNumberValidityDays: Output<Int>? = null

    private var trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>? = null

    private var trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var validateCharacterSet: Output<Boolean>? = null

    private var validateEDITypes: Output<Boolean>? = null

    private var validateXSDTypes: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("astrvijiebglckvr")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.allowLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The value indicating whether to check for duplicate group control number.
     */
    @JvmName("cxotwqnspcrssmlp")
    public suspend fun checkDuplicateGroupControlNumber(`value`: Output<Boolean>) {
        this.checkDuplicateGroupControlNumber = value
    }

    /**
     * @param value The value indicating whether to check for duplicate interchange control number.
     */
    @JvmName("onlwqhtsdjywwtqr")
    public suspend fun checkDuplicateInterchangeControlNumber(`value`: Output<Boolean>) {
        this.checkDuplicateInterchangeControlNumber = value
    }

    /**
     * @param value The value indicating whether to check for duplicate transaction set control number.
     */
    @JvmName("qyyyhmoqshibleyy")
    public suspend fun checkDuplicateTransactionSetControlNumber(`value`: Output<Boolean>) {
        this.checkDuplicateTransactionSetControlNumber = value
    }

    /**
     * @param value The validity period of interchange control number.
     */
    @JvmName("homeopebcgporddj")
    public suspend fun interchangeControlNumberValidityDays(`value`: Output<Int>) {
        this.interchangeControlNumberValidityDays = value
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("csrurgdyqqovqtvn")
    public suspend
    fun trailingSeparatorPolicy(`value`: Output<Either<String, TrailingSeparatorPolicy>>) {
        this.trailingSeparatorPolicy = value
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("qlfeapvcxgmmktlu")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.trimLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The value indicating whether to validate character set in the message.
     */
    @JvmName("nuvscunsfbwopvpo")
    public suspend fun validateCharacterSet(`value`: Output<Boolean>) {
        this.validateCharacterSet = value
    }

    /**
     * @param value The value indicating whether to Whether to validate EDI types.
     */
    @JvmName("tiovcbkrjrcqkiju")
    public suspend fun validateEDITypes(`value`: Output<Boolean>) {
        this.validateEDITypes = value
    }

    /**
     * @param value The value indicating whether to Whether to validate XSD types.
     */
    @JvmName("iagvhkjfctmihmls")
    public suspend fun validateXSDTypes(`value`: Output<Boolean>) {
        this.validateXSDTypes = value
    }

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("pserrggouctievoq")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The value indicating whether to check for duplicate group control number.
     */
    @JvmName("uekuxvnynjnwvtby")
    public suspend fun checkDuplicateGroupControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkDuplicateGroupControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to check for duplicate interchange control number.
     */
    @JvmName("mpwydphhmxjpvlfr")
    public suspend fun checkDuplicateInterchangeControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkDuplicateInterchangeControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to check for duplicate transaction set control number.
     */
    @JvmName("cepmnxbyrnaewmoc")
    public suspend fun checkDuplicateTransactionSetControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkDuplicateTransactionSetControlNumber = mapped
    }

    /**
     * @param value The validity period of interchange control number.
     */
    @JvmName("tjlnkwkdtpsueeny")
    public suspend fun interchangeControlNumberValidityDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeControlNumberValidityDays = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("qoisfimccxguitnj")
    public suspend fun trailingSeparatorPolicy(`value`: Either<String, TrailingSeparatorPolicy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("mkwhqdruxyaucabd")
    public fun trailingSeparatorPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("hsalsvhdbjkbqpce")
    public fun trailingSeparatorPolicy(`value`: TrailingSeparatorPolicy) {
        val toBeMapped = Either.ofRight<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("pcdvvthdxrbspokm")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trimLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The value indicating whether to validate character set in the message.
     */
    @JvmName("nsbhyljkgwhjytlo")
    public suspend fun validateCharacterSet(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateCharacterSet = mapped
    }

    /**
     * @param value The value indicating whether to Whether to validate EDI types.
     */
    @JvmName("kjuxlkuvanmahwxw")
    public suspend fun validateEDITypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateEDITypes = mapped
    }

    /**
     * @param value The value indicating whether to Whether to validate XSD types.
     */
    @JvmName("hjwqacjekjxkjeil")
    public suspend fun validateXSDTypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateXSDTypes = mapped
    }

    internal fun build(): EdifactValidationSettingsArgs = EdifactValidationSettingsArgs(
        allowLeadingAndTrailingSpacesAndZeroes = allowLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("allowLeadingAndTrailingSpacesAndZeroes"),
        checkDuplicateGroupControlNumber = checkDuplicateGroupControlNumber ?: throw
            PulumiNullFieldException("checkDuplicateGroupControlNumber"),
        checkDuplicateInterchangeControlNumber = checkDuplicateInterchangeControlNumber ?: throw
            PulumiNullFieldException("checkDuplicateInterchangeControlNumber"),
        checkDuplicateTransactionSetControlNumber = checkDuplicateTransactionSetControlNumber ?: throw
            PulumiNullFieldException("checkDuplicateTransactionSetControlNumber"),
        interchangeControlNumberValidityDays = interchangeControlNumberValidityDays ?: throw
            PulumiNullFieldException("interchangeControlNumberValidityDays"),
        trailingSeparatorPolicy = trailingSeparatorPolicy ?: throw
            PulumiNullFieldException("trailingSeparatorPolicy"),
        trimLeadingAndTrailingSpacesAndZeroes = trimLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("trimLeadingAndTrailingSpacesAndZeroes"),
        validateCharacterSet = validateCharacterSet ?: throw
            PulumiNullFieldException("validateCharacterSet"),
        validateEDITypes = validateEDITypes ?: throw PulumiNullFieldException("validateEDITypes"),
        validateXSDTypes = validateXSDTypes ?: throw PulumiNullFieldException("validateXSDTypes"),
    )
}
