@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The access control configuration.
 * @property actions The access control configuration for workflow actions.
 * @property contents The access control configuration for accessing workflow run contents.
 * @property triggers The access control configuration for invoking workflow triggers.
 * @property workflowManagement The access control configuration for workflow management.
 */
public data class FlowAccessControlConfigurationArgs(
    public val actions: Output<FlowAccessControlConfigurationPolicyArgs>? = null,
    public val contents: Output<FlowAccessControlConfigurationPolicyArgs>? = null,
    public val triggers: Output<FlowAccessControlConfigurationPolicyArgs>? = null,
    public val workflowManagement: Output<FlowAccessControlConfigurationPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationArgs =
        com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contents(contents?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggers(triggers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workflowManagement(
                workflowManagement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowAccessControlConfigurationArgs].
 */
@PulumiTagMarker
public class FlowAccessControlConfigurationArgsBuilder internal constructor() {
    private var actions: Output<FlowAccessControlConfigurationPolicyArgs>? = null

    private var contents: Output<FlowAccessControlConfigurationPolicyArgs>? = null

    private var triggers: Output<FlowAccessControlConfigurationPolicyArgs>? = null

    private var workflowManagement: Output<FlowAccessControlConfigurationPolicyArgs>? = null

    /**
     * @param value The access control configuration for workflow actions.
     */
    @JvmName("cwawdgcvxskecitv")
    public suspend fun actions(`value`: Output<FlowAccessControlConfigurationPolicyArgs>) {
        this.actions = value
    }

    /**
     * @param value The access control configuration for accessing workflow run contents.
     */
    @JvmName("useknyfnxiivdkan")
    public suspend fun contents(`value`: Output<FlowAccessControlConfigurationPolicyArgs>) {
        this.contents = value
    }

    /**
     * @param value The access control configuration for invoking workflow triggers.
     */
    @JvmName("fokpjvrmnbpfgyuh")
    public suspend fun triggers(`value`: Output<FlowAccessControlConfigurationPolicyArgs>) {
        this.triggers = value
    }

    /**
     * @param value The access control configuration for workflow management.
     */
    @JvmName("wxeowjwkhqthwlcl")
    public suspend fun workflowManagement(`value`: Output<FlowAccessControlConfigurationPolicyArgs>) {
        this.workflowManagement = value
    }

    /**
     * @param value The access control configuration for workflow actions.
     */
    @JvmName("swjhlxdvwjgxbnnx")
    public suspend fun actions(`value`: FlowAccessControlConfigurationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument The access control configuration for workflow actions.
     */
    @JvmName("kgduqlggnwocnmtm")
    public suspend
    fun actions(argument: suspend FlowAccessControlConfigurationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FlowAccessControlConfigurationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value The access control configuration for accessing workflow run contents.
     */
    @JvmName("bjsbftunlksueinq")
    public suspend fun contents(`value`: FlowAccessControlConfigurationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contents = mapped
    }

    /**
     * @param argument The access control configuration for accessing workflow run contents.
     */
    @JvmName("fepdsyfxhnwknyfe")
    public suspend
    fun contents(argument: suspend FlowAccessControlConfigurationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FlowAccessControlConfigurationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contents = mapped
    }

    /**
     * @param value The access control configuration for invoking workflow triggers.
     */
    @JvmName("telphsfrafvsyffi")
    public suspend fun triggers(`value`: FlowAccessControlConfigurationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param argument The access control configuration for invoking workflow triggers.
     */
    @JvmName("dgdhxeamgxrxnofr")
    public suspend
    fun triggers(argument: suspend FlowAccessControlConfigurationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FlowAccessControlConfigurationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param value The access control configuration for workflow management.
     */
    @JvmName("cltpjhaqbeqnbvhd")
    public suspend fun workflowManagement(`value`: FlowAccessControlConfigurationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowManagement = mapped
    }

    /**
     * @param argument The access control configuration for workflow management.
     */
    @JvmName("jkwwwweqvtewlksx")
    public suspend
    fun workflowManagement(argument: suspend FlowAccessControlConfigurationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FlowAccessControlConfigurationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workflowManagement = mapped
    }

    internal fun build(): FlowAccessControlConfigurationArgs = FlowAccessControlConfigurationArgs(
        actions = actions,
        contents = contents,
        triggers = triggers,
        workflowManagement = workflowManagement,
    )
}
