@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName The integration account certificate name.
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountCertificatePlainArgs(
    public val certificateName: String,
    public val integrationAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountCertificatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountCertificatePlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account certificate name.
     */
    @JvmName("odcuhgfopxfnstbg")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("xmhwqujyytadwaec")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("mtyjvnavykqqmttx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountCertificatePlainArgs =
        GetIntegrationAccountCertificatePlainArgs(
            certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
