@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPartnerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property partnerName The integration account partner name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountPartnerPlainArgs(
    public val integrationAccountName: String,
    public val partnerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPartnerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPartnerPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPartnerPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .partnerName(partnerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountPartnerPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountPartnerPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var partnerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("tvlebcvodwbxshdl")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The integration account partner name.
     */
    @JvmName("vqhaomcubrskchbc")
    public suspend fun partnerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jmnecdwqyjjetilv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountPartnerPlainArgs =
        GetIntegrationAccountPartnerPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            partnerName = partnerName ?: throw PulumiNullFieldException("partnerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
