@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName The api name.
 * @property integrationServiceEnvironmentName The integration service environment name.
 * @property resourceGroup The resource group name.
 */
public data class GetIntegrationServiceEnvironmentManagedApiPlainArgs(
    public val apiName: String,
    public val integrationServiceEnvironmentName: String,
    public val resourceGroup: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .integrationServiceEnvironmentName(integrationServiceEnvironmentName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationServiceEnvironmentManagedApiPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationServiceEnvironmentManagedApiPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var integrationServiceEnvironmentName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value The api name.
     */
    @JvmName("idvdmcqtthaiegup")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The integration service environment name.
     */
    @JvmName("qgtjqlxehnwbyyba")
    public suspend fun integrationServiceEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationServiceEnvironmentName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vmuamgyraoycrlax")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetIntegrationServiceEnvironmentManagedApiPlainArgs =
        GetIntegrationServiceEnvironmentManagedApiPlainArgs(
            apiName = apiName ?: throw PulumiNullFieldException("apiName"),
            integrationServiceEnvironmentName = integrationServiceEnvironmentName ?: throw
                PulumiNullFieldException("integrationServiceEnvironmentName"),
            resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
        )
}
