@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration service environment managed api deployment parameters.
 * @property contentLinkDefinition The integration service environment managed api content link for deployment.
 */
public data class IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs(
    public val contentLinkDefinition: Output<ContentLinkArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs.builder()
            .contentLinkDefinition(
                contentLinkDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentManagedApiDeploymentParametersArgsBuilder internal
constructor() {
    private var contentLinkDefinition: Output<ContentLinkArgs>? = null

    /**
     * @param value The integration service environment managed api content link for deployment.
     */
    @JvmName("sfokbvhkwcgttyja")
    public suspend fun contentLinkDefinition(`value`: Output<ContentLinkArgs>) {
        this.contentLinkDefinition = value
    }

    /**
     * @param value The integration service environment managed api content link for deployment.
     */
    @JvmName("nujxmnegqnqrikop")
    public suspend fun contentLinkDefinition(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLinkDefinition = mapped
    }

    /**
     * @param argument The integration service environment managed api content link for deployment.
     */
    @JvmName("kkbvacqoxbvuxfcj")
    public suspend fun contentLinkDefinition(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLinkDefinition = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs =
        IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs(
            contentLinkDefinition = contentLinkDefinition,
        )
}
