@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentSkuArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.IntegrationServiceEnvironmentSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration service environment sku.
 * @property capacity The sku capacity.
 * @property name The sku name.
 */
public data class IntegrationServiceEnvironmentSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, IntegrationServiceEnvironmentSkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentSkuArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentSkuArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, IntegrationServiceEnvironmentSkuName>>? = null

    /**
     * @param value The sku capacity.
     */
    @JvmName("vdexgghdubkgkqjh")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("fknskqjsfolwwwvk")
    public suspend fun name(`value`: Output<Either<String, IntegrationServiceEnvironmentSkuName>>) {
        this.name = value
    }

    /**
     * @param value The sku capacity.
     */
    @JvmName("gnxwyoqpmaqtvpee")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("slvhthafoprfxvgi")
    public suspend fun name(`value`: Either<String, IntegrationServiceEnvironmentSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("umgqkcdrmwysiamn")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationServiceEnvironmentSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("srkjvividpjxrpdp")
    public fun name(`value`: IntegrationServiceEnvironmentSkuName) {
        val toBeMapped = Either.ofRight<String, IntegrationServiceEnvironmentSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentSkuArgs = IntegrationServiceEnvironmentSkuArgs(
        capacity = capacity,
        name = name,
    )
}
