@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 * @property schemaName The integration account schema name.
 */
public data class ListIntegrationAccountSchemaContentCallbackUrlPlainArgs(
    public val integrationAccountName: String,
    public val keyType: Either<String, KeyType>? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
    public val schemaName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaName(schemaName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIntegrationAccountSchemaContentCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListIntegrationAccountSchemaContentCallbackUrlPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var keyType: Either<String, KeyType>? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    private var schemaName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("gfqrgwuujitlxmml")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("rqvfkgiwskvciylv")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("fcdxnhafwioxttrv")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("borvwafqobnwwoqf")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("kjtdnbkncpyepdlp")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sshobiflihlxurme")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account schema name.
     */
    @JvmName("gxvwrghbuswknwmg")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaName = mapped
    }

    internal fun build(): ListIntegrationAccountSchemaContentCallbackUrlPlainArgs =
        ListIntegrationAccountSchemaContentCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
        )
}
