@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowCallbackUrlPlainArgs(
    public val keyType: Either<String, KeyType>? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowCallbackUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ListWorkflowCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowCallbackUrlPlainArgs.builder()
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowCallbackUrlPlainArgsBuilder internal constructor() {
    private var keyType: Either<String, KeyType>? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The key type.
     */
    @JvmName("fbuwvsphaaauuycw")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("umtwbugygwxtnuox")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("mdwnpiqrbgutwswc")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("pddhqpxoxvuwjvbc")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yrvgcmdgygqhhgww")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("owfawetsnxbclmaf")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowCallbackUrlPlainArgs = ListWorkflowCallbackUrlPlainArgs(
        keyType = keyType,
        notAfter = notAfter,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
    )
}
