@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionExpressionTracesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionName The workflow action name.
 * @property resourceGroupName The resource group name.
 * @property runName The workflow run name.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowRunActionExpressionTracesPlainArgs(
    public val actionName: String,
    public val resourceGroupName: String,
    public val runName: String,
    public val workflowName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionExpressionTracesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionExpressionTracesPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionExpressionTracesPlainArgs.builder()
            .actionName(actionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runName(runName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowRunActionExpressionTracesPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowRunActionExpressionTracesPlainArgsBuilder internal constructor() {
    private var actionName: String? = null

    private var resourceGroupName: String? = null

    private var runName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The workflow action name.
     */
    @JvmName("dmanxeijvdkmbllx")
    public suspend fun actionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actionName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("iyagigdopcsicndp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow run name.
     */
    @JvmName("nqtyflypcuqyqmpy")
    public suspend fun runName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("ablqstgoevwcbcma")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowRunActionExpressionTracesPlainArgs =
        ListWorkflowRunActionExpressionTracesPlainArgs(
            actionName = actionName ?: throw PulumiNullFieldException("actionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            runName = runName ?: throw PulumiNullFieldException("runName"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
