@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AuthenticationPolicy of type Open.
 * @property policies Open authentication policies.
 */
public data class OpenAuthenticationAccessPoliciesArgs(
    public val policies: Output<Map<String, OpenAuthenticationAccessPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPoliciesArgs =
        com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPoliciesArgs.builder()
            .policies(
                policies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OpenAuthenticationAccessPoliciesArgs].
 */
@PulumiTagMarker
public class OpenAuthenticationAccessPoliciesArgsBuilder internal constructor() {
    private var policies: Output<Map<String, OpenAuthenticationAccessPolicyArgs>>? = null

    /**
     * @param value Open authentication policies.
     */
    @JvmName("gjundbdnlupklwxq")
    public suspend fun policies(`value`: Output<Map<String, OpenAuthenticationAccessPolicyArgs>>) {
        this.policies = value
    }

    /**
     * @param value Open authentication policies.
     */
    @JvmName("lofcmbnysaqexuqd")
    public suspend fun policies(`value`: Map<String, OpenAuthenticationAccessPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param argument Open authentication policies.
     */
    @JvmName("gvqjfaxvfutrioml")
    public suspend fun policies(
        vararg
        argument: Pair<String, suspend OpenAuthenticationAccessPolicyArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                OpenAuthenticationAccessPolicyArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param values Open authentication policies.
     */
    @JvmName("jkvyreaqoxmkfpog")
    public fun policies(vararg values: Pair<String, OpenAuthenticationAccessPolicyArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    internal fun build(): OpenAuthenticationAccessPoliciesArgs = OpenAuthenticationAccessPoliciesArgs(
        policies = policies,
    )
}
