@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RecurrenceScheduleArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.DaysOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The recurrence schedule.
 * @property hours The hours.
 * @property minutes The minutes.
 * @property monthDays The month days.
 * @property monthlyOccurrences The monthly occurrences.
 * @property weekDays The days of the week.
 */
public data class RecurrenceScheduleArgs(
    public val hours: Output<List<Int>>? = null,
    public val minutes: Output<List<Int>>? = null,
    public val monthDays: Output<List<Int>>? = null,
    public val monthlyOccurrences: Output<List<RecurrenceScheduleOccurrenceArgs>>? = null,
    public val weekDays: Output<List<DaysOfWeek>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RecurrenceScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RecurrenceScheduleArgs =
        com.pulumi.azurenative.logic.inputs.RecurrenceScheduleArgs.builder()
            .hours(hours?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .minutes(minutes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthDays(monthDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthlyOccurrences(
                monthlyOccurrences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .weekDays(
                weekDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RecurrenceScheduleArgs].
 */
@PulumiTagMarker
public class RecurrenceScheduleArgsBuilder internal constructor() {
    private var hours: Output<List<Int>>? = null

    private var minutes: Output<List<Int>>? = null

    private var monthDays: Output<List<Int>>? = null

    private var monthlyOccurrences: Output<List<RecurrenceScheduleOccurrenceArgs>>? = null

    private var weekDays: Output<List<DaysOfWeek>>? = null

    /**
     * @param value The hours.
     */
    @JvmName("nhmiwmfwxujhjrbt")
    public suspend fun hours(`value`: Output<List<Int>>) {
        this.hours = value
    }

    @JvmName("ftkniqbduxfotryb")
    public suspend fun hours(vararg values: Output<Int>) {
        this.hours = Output.all(values.asList())
    }

    /**
     * @param values The hours.
     */
    @JvmName("ucircpjlprqkkxob")
    public suspend fun hours(values: List<Output<Int>>) {
        this.hours = Output.all(values)
    }

    /**
     * @param value The minutes.
     */
    @JvmName("nhirbxrysuhntdog")
    public suspend fun minutes(`value`: Output<List<Int>>) {
        this.minutes = value
    }

    @JvmName("cgmevbedqunwvghd")
    public suspend fun minutes(vararg values: Output<Int>) {
        this.minutes = Output.all(values.asList())
    }

    /**
     * @param values The minutes.
     */
    @JvmName("fbquwqhjfooekpoc")
    public suspend fun minutes(values: List<Output<Int>>) {
        this.minutes = Output.all(values)
    }

    /**
     * @param value The month days.
     */
    @JvmName("bvqjvfqioawqheip")
    public suspend fun monthDays(`value`: Output<List<Int>>) {
        this.monthDays = value
    }

    @JvmName("wtygxgbfrbkopnsn")
    public suspend fun monthDays(vararg values: Output<Int>) {
        this.monthDays = Output.all(values.asList())
    }

    /**
     * @param values The month days.
     */
    @JvmName("bheioksubxumqjll")
    public suspend fun monthDays(values: List<Output<Int>>) {
        this.monthDays = Output.all(values)
    }

    /**
     * @param value The monthly occurrences.
     */
    @JvmName("jmnqkycdnnjbdonf")
    public suspend fun monthlyOccurrences(`value`: Output<List<RecurrenceScheduleOccurrenceArgs>>) {
        this.monthlyOccurrences = value
    }

    @JvmName("ulhltcxpcfonppda")
    public suspend fun monthlyOccurrences(vararg values: Output<RecurrenceScheduleOccurrenceArgs>) {
        this.monthlyOccurrences = Output.all(values.asList())
    }

    /**
     * @param values The monthly occurrences.
     */
    @JvmName("ojbcfirsianabyje")
    public suspend fun monthlyOccurrences(values: List<Output<RecurrenceScheduleOccurrenceArgs>>) {
        this.monthlyOccurrences = Output.all(values)
    }

    /**
     * @param value The days of the week.
     */
    @JvmName("vjwgbawxyeafoxyq")
    public suspend fun weekDays(`value`: Output<List<DaysOfWeek>>) {
        this.weekDays = value
    }

    @JvmName("plrfldpjsjhelrtc")
    public suspend fun weekDays(vararg values: Output<DaysOfWeek>) {
        this.weekDays = Output.all(values.asList())
    }

    /**
     * @param values The days of the week.
     */
    @JvmName("jqibbdxdwederprf")
    public suspend fun weekDays(values: List<Output<DaysOfWeek>>) {
        this.weekDays = Output.all(values)
    }

    /**
     * @param value The hours.
     */
    @JvmName("wnpdtkwpworrjnii")
    public suspend fun hours(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param values The hours.
     */
    @JvmName("xmqowyjgtuateoeu")
    public suspend fun hours(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value The minutes.
     */
    @JvmName("gcubnwngwrdyojkq")
    public suspend fun minutes(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param values The minutes.
     */
    @JvmName("ffqaiamttsqrnjgw")
    public suspend fun minutes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param value The month days.
     */
    @JvmName("ayuvudjtedrxllun")
    public suspend fun monthDays(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param values The month days.
     */
    @JvmName("kednqhmuawwgwakp")
    public suspend fun monthDays(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param value The monthly occurrences.
     */
    @JvmName("vwjtryeccjskerue")
    public suspend fun monthlyOccurrences(`value`: List<RecurrenceScheduleOccurrenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument The monthly occurrences.
     */
    @JvmName("firimpcdksfurarb")
    public suspend
    fun monthlyOccurrences(argument: List<suspend RecurrenceScheduleOccurrenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecurrenceScheduleOccurrenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument The monthly occurrences.
     */
    @JvmName("tjvojxhrbhwpavgk")
    public suspend fun monthlyOccurrences(
        vararg
        argument: suspend RecurrenceScheduleOccurrenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecurrenceScheduleOccurrenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument The monthly occurrences.
     */
    @JvmName("qciphvfnjynsanmo")
    public suspend
    fun monthlyOccurrences(argument: suspend RecurrenceScheduleOccurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecurrenceScheduleOccurrenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param values The monthly occurrences.
     */
    @JvmName("dreoyymlskfmrkfs")
    public suspend fun monthlyOccurrences(vararg values: RecurrenceScheduleOccurrenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param value The days of the week.
     */
    @JvmName("murmmxfvymuafhbb")
    public suspend fun weekDays(`value`: List<DaysOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    /**
     * @param values The days of the week.
     */
    @JvmName("fongglyhjsmslwnb")
    public suspend fun weekDays(vararg values: DaysOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    internal fun build(): RecurrenceScheduleArgs = RecurrenceScheduleArgs(
        hours = hours,
        minutes = minutes,
        monthDays = monthDays,
        monthlyOccurrences = monthlyOccurrences,
        weekDays = weekDays,
    )
}
