@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration account RosettaNet ProcessConfiguration Acknowledgement settings.
 * @property isNonRepudiationRequired The non-repudiation is required or not.
 * @property timeToAcknowledgeInSeconds The time to acknowledge in seconds.
 */
public data class RosettaNetPipAcknowledgmentOfReceiptSettingsArgs(
    public val isNonRepudiationRequired: Output<Boolean>,
    public val timeToAcknowledgeInSeconds: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs =
        com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs.builder()
            .isNonRepudiationRequired(isNonRepudiationRequired.applyValue({ args0 -> args0 }))
            .timeToAcknowledgeInSeconds(timeToAcknowledgeInSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RosettaNetPipAcknowledgmentOfReceiptSettingsArgs].
 */
@PulumiTagMarker
public class RosettaNetPipAcknowledgmentOfReceiptSettingsArgsBuilder internal constructor() {
    private var isNonRepudiationRequired: Output<Boolean>? = null

    private var timeToAcknowledgeInSeconds: Output<Int>? = null

    /**
     * @param value The non-repudiation is required or not.
     */
    @JvmName("prcdebajamfyesuq")
    public suspend fun isNonRepudiationRequired(`value`: Output<Boolean>) {
        this.isNonRepudiationRequired = value
    }

    /**
     * @param value The time to acknowledge in seconds.
     */
    @JvmName("yuermeafelhpkueq")
    public suspend fun timeToAcknowledgeInSeconds(`value`: Output<Int>) {
        this.timeToAcknowledgeInSeconds = value
    }

    /**
     * @param value The non-repudiation is required or not.
     */
    @JvmName("xfnlvjteqgicxluv")
    public suspend fun isNonRepudiationRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isNonRepudiationRequired = mapped
    }

    /**
     * @param value The time to acknowledge in seconds.
     */
    @JvmName("uhxmihwbbhlafusq")
    public suspend fun timeToAcknowledgeInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeToAcknowledgeInSeconds = mapped
    }

    internal fun build(): RosettaNetPipAcknowledgmentOfReceiptSettingsArgs =
        RosettaNetPipAcknowledgmentOfReceiptSettingsArgs(
            isNonRepudiationRequired = isNonRepudiationRequired ?: throw
                PulumiNullFieldException("isNonRepudiationRequired"),
            timeToAcknowledgeInSeconds = timeToAcknowledgeInSeconds ?: throw
                PulumiNullFieldException("timeToAcknowledgeInSeconds"),
        )
}
