@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The RosettaNet ProcessConfiguration business document settings.
 * @property description The business document description.
 * @property name The business document name.
 * @property version The business document version.
 */
public data class RosettaNetPipBusinessDocumentArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs =
        com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RosettaNetPipBusinessDocumentArgs].
 */
@PulumiTagMarker
public class RosettaNetPipBusinessDocumentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The business document description.
     */
    @JvmName("gajibopdpmojqpvm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The business document name.
     */
    @JvmName("nmvyqoymcgtgeocp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The business document version.
     */
    @JvmName("vimhxcyupbqcxmcp")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The business document description.
     */
    @JvmName("nepccuiseaytgkak")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The business document name.
     */
    @JvmName("cjmkycsxtphgmqps")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The business document version.
     */
    @JvmName("yqlvovoyasnrjsfn")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RosettaNetPipBusinessDocumentArgs = RosettaNetPipBusinessDocumentArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
