@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.WorkflowParameterArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The workflow parameters.
 * @property description The description.
 * @property metadata The metadata.
 * @property type The type.
 * @property value The value.
 */
public data class WorkflowParameterArgs(
    public val description: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val type: Output<Either<String, ParameterType>>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.WorkflowParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.WorkflowParameterArgs =
        com.pulumi.azurenative.logic.inputs.WorkflowParameterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowParameterArgs].
 */
@PulumiTagMarker
public class WorkflowParameterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value The description.
     */
    @JvmName("exycoqvmqnbgnnms")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("ricifkbvjerikmff")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The type.
     */
    @JvmName("shmnxfvmwjstsxmy")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value The value.
     */
    @JvmName("tqlnbxxaumpbpiyq")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value The description.
     */
    @JvmName("mmtjrvopdfsjyttj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("jdposarhrynofgwm")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The type.
     */
    @JvmName("wlaqfyuwnhpsgufm")
    public suspend fun type(`value`: Either<String, ParameterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type.
     */
    @JvmName("pomoygdqfmxrsdoy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type.
     */
    @JvmName("njfrbxtjwtjpuqme")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value.
     */
    @JvmName("feabmmjosabnokae")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WorkflowParameterArgs = WorkflowParameterArgs(
        description = description,
        metadata = metadata,
        type = type,
        `value` = `value`,
    )
}
