@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12AcknowledgementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 agreement acknowledgement settings.
 * @property acknowledgementControlNumberLowerBound The acknowledgement control number lower bound.
 * @property acknowledgementControlNumberPrefix The acknowledgement control number prefix.
 * @property acknowledgementControlNumberSuffix The acknowledgement control number suffix.
 * @property acknowledgementControlNumberUpperBound The acknowledgement control number upper bound.
 * @property batchFunctionalAcknowledgements The value indicating whether to batch functional acknowledgements.
 * @property batchImplementationAcknowledgements The value indicating whether to batch implementation acknowledgements.
 * @property batchTechnicalAcknowledgements The value indicating whether to batch the technical acknowledgements.
 * @property functionalAcknowledgementVersion The functional acknowledgement version.
 * @property implementationAcknowledgementVersion The implementation acknowledgement version.
 * @property needFunctionalAcknowledgement The value indicating whether functional acknowledgement is needed.
 * @property needImplementationAcknowledgement The value indicating whether implementation acknowledgement is needed.
 * @property needLoopForValidMessages The value indicating whether a loop is needed for valid messages.
 * @property needTechnicalAcknowledgement The value indicating whether technical acknowledgement is needed.
 * @property rolloverAcknowledgementControlNumber The value indicating whether to rollover acknowledgement control number.
 * @property sendSynchronousAcknowledgement The value indicating whether to send synchronous acknowledgement.
 */
public data class X12AcknowledgementSettingsArgs(
    public val acknowledgementControlNumberLowerBound: Output<Int>,
    public val acknowledgementControlNumberPrefix: Output<String>? = null,
    public val acknowledgementControlNumberSuffix: Output<String>? = null,
    public val acknowledgementControlNumberUpperBound: Output<Int>,
    public val batchFunctionalAcknowledgements: Output<Boolean>,
    public val batchImplementationAcknowledgements: Output<Boolean>,
    public val batchTechnicalAcknowledgements: Output<Boolean>,
    public val functionalAcknowledgementVersion: Output<String>? = null,
    public val implementationAcknowledgementVersion: Output<String>? = null,
    public val needFunctionalAcknowledgement: Output<Boolean>,
    public val needImplementationAcknowledgement: Output<Boolean>,
    public val needLoopForValidMessages: Output<Boolean>,
    public val needTechnicalAcknowledgement: Output<Boolean>,
    public val rolloverAcknowledgementControlNumber: Output<Boolean>,
    public val sendSynchronousAcknowledgement: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12AcknowledgementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12AcknowledgementSettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12AcknowledgementSettingsArgs.builder()
            .acknowledgementControlNumberLowerBound(
                acknowledgementControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberPrefix(
                acknowledgementControlNumberPrefix?.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberSuffix(
                acknowledgementControlNumberSuffix?.applyValue({ args0 ->
                    args0
                }),
            )
            .acknowledgementControlNumberUpperBound(
                acknowledgementControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            )
            .batchFunctionalAcknowledgements(batchFunctionalAcknowledgements.applyValue({ args0 -> args0 }))
            .batchImplementationAcknowledgements(
                batchImplementationAcknowledgements.applyValue({ args0 ->
                    args0
                }),
            )
            .batchTechnicalAcknowledgements(batchTechnicalAcknowledgements.applyValue({ args0 -> args0 }))
            .functionalAcknowledgementVersion(functionalAcknowledgementVersion?.applyValue({ args0 -> args0 }))
            .implementationAcknowledgementVersion(
                implementationAcknowledgementVersion?.applyValue({ args0 ->
                    args0
                }),
            )
            .needFunctionalAcknowledgement(needFunctionalAcknowledgement.applyValue({ args0 -> args0 }))
            .needImplementationAcknowledgement(needImplementationAcknowledgement.applyValue({ args0 -> args0 }))
            .needLoopForValidMessages(needLoopForValidMessages.applyValue({ args0 -> args0 }))
            .needTechnicalAcknowledgement(needTechnicalAcknowledgement.applyValue({ args0 -> args0 }))
            .rolloverAcknowledgementControlNumber(
                rolloverAcknowledgementControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .sendSynchronousAcknowledgement(
                sendSynchronousAcknowledgement.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [X12AcknowledgementSettingsArgs].
 */
@PulumiTagMarker
public class X12AcknowledgementSettingsArgsBuilder internal constructor() {
    private var acknowledgementControlNumberLowerBound: Output<Int>? = null

    private var acknowledgementControlNumberPrefix: Output<String>? = null

    private var acknowledgementControlNumberSuffix: Output<String>? = null

    private var acknowledgementControlNumberUpperBound: Output<Int>? = null

    private var batchFunctionalAcknowledgements: Output<Boolean>? = null

    private var batchImplementationAcknowledgements: Output<Boolean>? = null

    private var batchTechnicalAcknowledgements: Output<Boolean>? = null

    private var functionalAcknowledgementVersion: Output<String>? = null

    private var implementationAcknowledgementVersion: Output<String>? = null

    private var needFunctionalAcknowledgement: Output<Boolean>? = null

    private var needImplementationAcknowledgement: Output<Boolean>? = null

    private var needLoopForValidMessages: Output<Boolean>? = null

    private var needTechnicalAcknowledgement: Output<Boolean>? = null

    private var rolloverAcknowledgementControlNumber: Output<Boolean>? = null

    private var sendSynchronousAcknowledgement: Output<Boolean>? = null

    /**
     * @param value The acknowledgement control number lower bound.
     */
    @JvmName("prgthmcetftqtmlc")
    public suspend fun acknowledgementControlNumberLowerBound(`value`: Output<Int>) {
        this.acknowledgementControlNumberLowerBound = value
    }

    /**
     * @param value The acknowledgement control number prefix.
     */
    @JvmName("xgrkjepgkspekxsq")
    public suspend fun acknowledgementControlNumberPrefix(`value`: Output<String>) {
        this.acknowledgementControlNumberPrefix = value
    }

    /**
     * @param value The acknowledgement control number suffix.
     */
    @JvmName("bhbacvifqcjuhoup")
    public suspend fun acknowledgementControlNumberSuffix(`value`: Output<String>) {
        this.acknowledgementControlNumberSuffix = value
    }

    /**
     * @param value The acknowledgement control number upper bound.
     */
    @JvmName("fmvxlnnxdxadqdpf")
    public suspend fun acknowledgementControlNumberUpperBound(`value`: Output<Int>) {
        this.acknowledgementControlNumberUpperBound = value
    }

    /**
     * @param value The value indicating whether to batch functional acknowledgements.
     */
    @JvmName("nahiiklxuacmuusp")
    public suspend fun batchFunctionalAcknowledgements(`value`: Output<Boolean>) {
        this.batchFunctionalAcknowledgements = value
    }

    /**
     * @param value The value indicating whether to batch implementation acknowledgements.
     */
    @JvmName("yuloyoipvpsymigs")
    public suspend fun batchImplementationAcknowledgements(`value`: Output<Boolean>) {
        this.batchImplementationAcknowledgements = value
    }

    /**
     * @param value The value indicating whether to batch the technical acknowledgements.
     */
    @JvmName("kklbdcwubueyaoqa")
    public suspend fun batchTechnicalAcknowledgements(`value`: Output<Boolean>) {
        this.batchTechnicalAcknowledgements = value
    }

    /**
     * @param value The functional acknowledgement version.
     */
    @JvmName("ppgegoridojoxown")
    public suspend fun functionalAcknowledgementVersion(`value`: Output<String>) {
        this.functionalAcknowledgementVersion = value
    }

    /**
     * @param value The implementation acknowledgement version.
     */
    @JvmName("wtnoewxtvkdnvvqk")
    public suspend fun implementationAcknowledgementVersion(`value`: Output<String>) {
        this.implementationAcknowledgementVersion = value
    }

    /**
     * @param value The value indicating whether functional acknowledgement is needed.
     */
    @JvmName("cwtwfgvrnajaigpo")
    public suspend fun needFunctionalAcknowledgement(`value`: Output<Boolean>) {
        this.needFunctionalAcknowledgement = value
    }

    /**
     * @param value The value indicating whether implementation acknowledgement is needed.
     */
    @JvmName("vrbqfytfbueccgwn")
    public suspend fun needImplementationAcknowledgement(`value`: Output<Boolean>) {
        this.needImplementationAcknowledgement = value
    }

    /**
     * @param value The value indicating whether a loop is needed for valid messages.
     */
    @JvmName("wxjgqjwdiopfoheh")
    public suspend fun needLoopForValidMessages(`value`: Output<Boolean>) {
        this.needLoopForValidMessages = value
    }

    /**
     * @param value The value indicating whether technical acknowledgement is needed.
     */
    @JvmName("mgyjlettdteugekw")
    public suspend fun needTechnicalAcknowledgement(`value`: Output<Boolean>) {
        this.needTechnicalAcknowledgement = value
    }

    /**
     * @param value The value indicating whether to rollover acknowledgement control number.
     */
    @JvmName("pcdpjqofhdlfpokg")
    public suspend fun rolloverAcknowledgementControlNumber(`value`: Output<Boolean>) {
        this.rolloverAcknowledgementControlNumber = value
    }

    /**
     * @param value The value indicating whether to send synchronous acknowledgement.
     */
    @JvmName("krwwlmdrooxnasxt")
    public suspend fun sendSynchronousAcknowledgement(`value`: Output<Boolean>) {
        this.sendSynchronousAcknowledgement = value
    }

    /**
     * @param value The acknowledgement control number lower bound.
     */
    @JvmName("xjtwjcjnemrnoijn")
    public suspend fun acknowledgementControlNumberLowerBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberLowerBound = mapped
    }

    /**
     * @param value The acknowledgement control number prefix.
     */
    @JvmName("dcyxrsnwvijxeutu")
    public suspend fun acknowledgementControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberPrefix = mapped
    }

    /**
     * @param value The acknowledgement control number suffix.
     */
    @JvmName("gnprordkanoiyxca")
    public suspend fun acknowledgementControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberSuffix = mapped
    }

    /**
     * @param value The acknowledgement control number upper bound.
     */
    @JvmName("spssvwfplubprhay")
    public suspend fun acknowledgementControlNumberUpperBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementControlNumberUpperBound = mapped
    }

    /**
     * @param value The value indicating whether to batch functional acknowledgements.
     */
    @JvmName("vqqjlbgjcfrooftd")
    public suspend fun batchFunctionalAcknowledgements(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchFunctionalAcknowledgements = mapped
    }

    /**
     * @param value The value indicating whether to batch implementation acknowledgements.
     */
    @JvmName("wjscplbwcstjeagb")
    public suspend fun batchImplementationAcknowledgements(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchImplementationAcknowledgements = mapped
    }

    /**
     * @param value The value indicating whether to batch the technical acknowledgements.
     */
    @JvmName("jwoxqwtyrwfjirjn")
    public suspend fun batchTechnicalAcknowledgements(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchTechnicalAcknowledgements = mapped
    }

    /**
     * @param value The functional acknowledgement version.
     */
    @JvmName("pchvsaqchgutexha")
    public suspend fun functionalAcknowledgementVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionalAcknowledgementVersion = mapped
    }

    /**
     * @param value The implementation acknowledgement version.
     */
    @JvmName("ceudsnocsaxgrowb")
    public suspend fun implementationAcknowledgementVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.implementationAcknowledgementVersion = mapped
    }

    /**
     * @param value The value indicating whether functional acknowledgement is needed.
     */
    @JvmName("mqvjmhgwccmbmtog")
    public suspend fun needFunctionalAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needFunctionalAcknowledgement = mapped
    }

    /**
     * @param value The value indicating whether implementation acknowledgement is needed.
     */
    @JvmName("ycfnnuarcnjcwodr")
    public suspend fun needImplementationAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needImplementationAcknowledgement = mapped
    }

    /**
     * @param value The value indicating whether a loop is needed for valid messages.
     */
    @JvmName("jqspovapahsaffuk")
    public suspend fun needLoopForValidMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needLoopForValidMessages = mapped
    }

    /**
     * @param value The value indicating whether technical acknowledgement is needed.
     */
    @JvmName("pphstlrqnwtmfyvj")
    public suspend fun needTechnicalAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needTechnicalAcknowledgement = mapped
    }

    /**
     * @param value The value indicating whether to rollover acknowledgement control number.
     */
    @JvmName("aeuyrccodrlalfsa")
    public suspend fun rolloverAcknowledgementControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverAcknowledgementControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to send synchronous acknowledgement.
     */
    @JvmName("djkqeooyylhnjsvt")
    public suspend fun sendSynchronousAcknowledgement(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendSynchronousAcknowledgement = mapped
    }

    internal fun build(): X12AcknowledgementSettingsArgs = X12AcknowledgementSettingsArgs(
        acknowledgementControlNumberLowerBound = acknowledgementControlNumberLowerBound ?: throw
            PulumiNullFieldException("acknowledgementControlNumberLowerBound"),
        acknowledgementControlNumberPrefix = acknowledgementControlNumberPrefix,
        acknowledgementControlNumberSuffix = acknowledgementControlNumberSuffix,
        acknowledgementControlNumberUpperBound = acknowledgementControlNumberUpperBound ?: throw
            PulumiNullFieldException("acknowledgementControlNumberUpperBound"),
        batchFunctionalAcknowledgements = batchFunctionalAcknowledgements ?: throw
            PulumiNullFieldException("batchFunctionalAcknowledgements"),
        batchImplementationAcknowledgements = batchImplementationAcknowledgements ?: throw
            PulumiNullFieldException("batchImplementationAcknowledgements"),
        batchTechnicalAcknowledgements = batchTechnicalAcknowledgements ?: throw
            PulumiNullFieldException("batchTechnicalAcknowledgements"),
        functionalAcknowledgementVersion = functionalAcknowledgementVersion,
        implementationAcknowledgementVersion = implementationAcknowledgementVersion,
        needFunctionalAcknowledgement = needFunctionalAcknowledgement ?: throw
            PulumiNullFieldException("needFunctionalAcknowledgement"),
        needImplementationAcknowledgement = needImplementationAcknowledgement ?: throw
            PulumiNullFieldException("needImplementationAcknowledgement"),
        needLoopForValidMessages = needLoopForValidMessages ?: throw
            PulumiNullFieldException("needLoopForValidMessages"),
        needTechnicalAcknowledgement = needTechnicalAcknowledgement ?: throw
            PulumiNullFieldException("needTechnicalAcknowledgement"),
        rolloverAcknowledgementControlNumber = rolloverAcknowledgementControlNumber ?: throw
            PulumiNullFieldException("rolloverAcknowledgementControlNumber"),
        sendSynchronousAcknowledgement = sendSynchronousAcknowledgement ?: throw
            PulumiNullFieldException("sendSynchronousAcknowledgement"),
    )
}
