@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12ProtocolSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The X12 agreement protocol settings.
 * @property acknowledgementSettings The X12 acknowledgment settings.
 * @property envelopeOverrides The X12 envelope override settings.
 * @property envelopeSettings The X12 envelope settings.
 * @property framingSettings The X12 framing settings.
 * @property messageFilter The X12 message filter.
 * @property messageFilterList The X12 message filter list.
 * @property processingSettings The X12 processing settings.
 * @property schemaReferences The X12 schema references.
 * @property securitySettings The X12 security settings.
 * @property validationOverrides The X12 validation override settings.
 * @property validationSettings The X12 validation settings.
 * @property x12DelimiterOverrides The X12 delimiter override settings.
 */
public data class X12ProtocolSettingsArgs(
    public val acknowledgementSettings: Output<X12AcknowledgementSettingsArgs>,
    public val envelopeOverrides: Output<List<X12EnvelopeOverrideArgs>>? = null,
    public val envelopeSettings: Output<X12EnvelopeSettingsArgs>,
    public val framingSettings: Output<X12FramingSettingsArgs>,
    public val messageFilter: Output<X12MessageFilterArgs>,
    public val messageFilterList: Output<List<X12MessageIdentifierArgs>>? = null,
    public val processingSettings: Output<X12ProcessingSettingsArgs>,
    public val schemaReferences: Output<List<X12SchemaReferenceArgs>>,
    public val securitySettings: Output<X12SecuritySettingsArgs>,
    public val validationOverrides: Output<List<X12ValidationOverrideArgs>>? = null,
    public val validationSettings: Output<X12ValidationSettingsArgs>,
    public val x12DelimiterOverrides: Output<List<X12DelimiterOverridesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12ProtocolSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12ProtocolSettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12ProtocolSettingsArgs.builder()
            .acknowledgementSettings(
                acknowledgementSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .envelopeOverrides(
                envelopeOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .envelopeSettings(envelopeSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .framingSettings(framingSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilter(messageFilter.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilterList(
                messageFilterList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processingSettings(
                processingSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaReferences(
                schemaReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .securitySettings(securitySettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationOverrides(
                validationOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .validationSettings(
                validationSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .x12DelimiterOverrides(
                x12DelimiterOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [X12ProtocolSettingsArgs].
 */
@PulumiTagMarker
public class X12ProtocolSettingsArgsBuilder internal constructor() {
    private var acknowledgementSettings: Output<X12AcknowledgementSettingsArgs>? = null

    private var envelopeOverrides: Output<List<X12EnvelopeOverrideArgs>>? = null

    private var envelopeSettings: Output<X12EnvelopeSettingsArgs>? = null

    private var framingSettings: Output<X12FramingSettingsArgs>? = null

    private var messageFilter: Output<X12MessageFilterArgs>? = null

    private var messageFilterList: Output<List<X12MessageIdentifierArgs>>? = null

    private var processingSettings: Output<X12ProcessingSettingsArgs>? = null

    private var schemaReferences: Output<List<X12SchemaReferenceArgs>>? = null

    private var securitySettings: Output<X12SecuritySettingsArgs>? = null

    private var validationOverrides: Output<List<X12ValidationOverrideArgs>>? = null

    private var validationSettings: Output<X12ValidationSettingsArgs>? = null

    private var x12DelimiterOverrides: Output<List<X12DelimiterOverridesArgs>>? = null

    /**
     * @param value The X12 acknowledgment settings.
     */
    @JvmName("qaumwoptqwfxplva")
    public suspend fun acknowledgementSettings(`value`: Output<X12AcknowledgementSettingsArgs>) {
        this.acknowledgementSettings = value
    }

    /**
     * @param value The X12 envelope override settings.
     */
    @JvmName("httpllviowwaboav")
    public suspend fun envelopeOverrides(`value`: Output<List<X12EnvelopeOverrideArgs>>) {
        this.envelopeOverrides = value
    }

    @JvmName("somfarprpsofkgpo")
    public suspend fun envelopeOverrides(vararg values: Output<X12EnvelopeOverrideArgs>) {
        this.envelopeOverrides = Output.all(values.asList())
    }

    /**
     * @param values The X12 envelope override settings.
     */
    @JvmName("omaaldikmqqcoyxy")
    public suspend fun envelopeOverrides(values: List<Output<X12EnvelopeOverrideArgs>>) {
        this.envelopeOverrides = Output.all(values)
    }

    /**
     * @param value The X12 envelope settings.
     */
    @JvmName("qjyuajfgumejkfxp")
    public suspend fun envelopeSettings(`value`: Output<X12EnvelopeSettingsArgs>) {
        this.envelopeSettings = value
    }

    /**
     * @param value The X12 framing settings.
     */
    @JvmName("hijurnvfvcrfssfo")
    public suspend fun framingSettings(`value`: Output<X12FramingSettingsArgs>) {
        this.framingSettings = value
    }

    /**
     * @param value The X12 message filter.
     */
    @JvmName("klerejfbhohmfgkg")
    public suspend fun messageFilter(`value`: Output<X12MessageFilterArgs>) {
        this.messageFilter = value
    }

    /**
     * @param value The X12 message filter list.
     */
    @JvmName("jcqvuspvhrjrotur")
    public suspend fun messageFilterList(`value`: Output<List<X12MessageIdentifierArgs>>) {
        this.messageFilterList = value
    }

    @JvmName("ksqxgggketckntbf")
    public suspend fun messageFilterList(vararg values: Output<X12MessageIdentifierArgs>) {
        this.messageFilterList = Output.all(values.asList())
    }

    /**
     * @param values The X12 message filter list.
     */
    @JvmName("khdkfcmeyhkkbujc")
    public suspend fun messageFilterList(values: List<Output<X12MessageIdentifierArgs>>) {
        this.messageFilterList = Output.all(values)
    }

    /**
     * @param value The X12 processing settings.
     */
    @JvmName("yjicqupppurxhall")
    public suspend fun processingSettings(`value`: Output<X12ProcessingSettingsArgs>) {
        this.processingSettings = value
    }

    /**
     * @param value The X12 schema references.
     */
    @JvmName("ktslpwnppcdtbase")
    public suspend fun schemaReferences(`value`: Output<List<X12SchemaReferenceArgs>>) {
        this.schemaReferences = value
    }

    @JvmName("fwsrhvsayoukdydd")
    public suspend fun schemaReferences(vararg values: Output<X12SchemaReferenceArgs>) {
        this.schemaReferences = Output.all(values.asList())
    }

    /**
     * @param values The X12 schema references.
     */
    @JvmName("udleyijsrhakpvvt")
    public suspend fun schemaReferences(values: List<Output<X12SchemaReferenceArgs>>) {
        this.schemaReferences = Output.all(values)
    }

    /**
     * @param value The X12 security settings.
     */
    @JvmName("kvvnyjnqondjmsxt")
    public suspend fun securitySettings(`value`: Output<X12SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value The X12 validation override settings.
     */
    @JvmName("xfehblhvesveibwe")
    public suspend fun validationOverrides(`value`: Output<List<X12ValidationOverrideArgs>>) {
        this.validationOverrides = value
    }

    @JvmName("jcxfumfrwpikvdwa")
    public suspend fun validationOverrides(vararg values: Output<X12ValidationOverrideArgs>) {
        this.validationOverrides = Output.all(values.asList())
    }

    /**
     * @param values The X12 validation override settings.
     */
    @JvmName("aimuobrrhqprduvl")
    public suspend fun validationOverrides(values: List<Output<X12ValidationOverrideArgs>>) {
        this.validationOverrides = Output.all(values)
    }

    /**
     * @param value The X12 validation settings.
     */
    @JvmName("viyliyxaogngpuvx")
    public suspend fun validationSettings(`value`: Output<X12ValidationSettingsArgs>) {
        this.validationSettings = value
    }

    /**
     * @param value The X12 delimiter override settings.
     */
    @JvmName("rsvexfjlacppadev")
    public suspend fun x12DelimiterOverrides(`value`: Output<List<X12DelimiterOverridesArgs>>) {
        this.x12DelimiterOverrides = value
    }

    @JvmName("ghxhdovcsumsiueh")
    public suspend fun x12DelimiterOverrides(vararg values: Output<X12DelimiterOverridesArgs>) {
        this.x12DelimiterOverrides = Output.all(values.asList())
    }

    /**
     * @param values The X12 delimiter override settings.
     */
    @JvmName("lvvfydbgtxaesffn")
    public suspend fun x12DelimiterOverrides(values: List<Output<X12DelimiterOverridesArgs>>) {
        this.x12DelimiterOverrides = Output.all(values)
    }

    /**
     * @param value The X12 acknowledgment settings.
     */
    @JvmName("aijsuwoqtaxangiq")
    public suspend fun acknowledgementSettings(`value`: X12AcknowledgementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementSettings = mapped
    }

    /**
     * @param argument The X12 acknowledgment settings.
     */
    @JvmName("jsewnvntwaraqlkb")
    public suspend
    fun acknowledgementSettings(argument: suspend X12AcknowledgementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12AcknowledgementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.acknowledgementSettings = mapped
    }

    /**
     * @param value The X12 envelope override settings.
     */
    @JvmName("nesktrqhoodpdysa")
    public suspend fun envelopeOverrides(`value`: List<X12EnvelopeOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The X12 envelope override settings.
     */
    @JvmName("blpdlnlvyxemdvgp")
    public suspend
    fun envelopeOverrides(argument: List<suspend X12EnvelopeOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X12EnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The X12 envelope override settings.
     */
    @JvmName("fmpsdwntqunvbdxq")
    public suspend fun envelopeOverrides(
        vararg
        argument: suspend X12EnvelopeOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X12EnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The X12 envelope override settings.
     */
    @JvmName("ljrtmntixivmqtyq")
    public suspend
    fun envelopeOverrides(argument: suspend X12EnvelopeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X12EnvelopeOverrideArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param values The X12 envelope override settings.
     */
    @JvmName("blpvwvmeaoaaojge")
    public suspend fun envelopeOverrides(vararg values: X12EnvelopeOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param value The X12 envelope settings.
     */
    @JvmName("yhjxvsjnricajitp")
    public suspend fun envelopeSettings(`value`: X12EnvelopeSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeSettings = mapped
    }

    /**
     * @param argument The X12 envelope settings.
     */
    @JvmName("iqodaxjktmiypbpt")
    public suspend fun envelopeSettings(argument: suspend X12EnvelopeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12EnvelopeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envelopeSettings = mapped
    }

    /**
     * @param value The X12 framing settings.
     */
    @JvmName("jfqpyqfakqghlksa")
    public suspend fun framingSettings(`value`: X12FramingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.framingSettings = mapped
    }

    /**
     * @param argument The X12 framing settings.
     */
    @JvmName("hkqxdsgtpfwjerdn")
    public suspend fun framingSettings(argument: suspend X12FramingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12FramingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.framingSettings = mapped
    }

    /**
     * @param value The X12 message filter.
     */
    @JvmName("qrwyfavydkuvpxob")
    public suspend fun messageFilter(`value`: X12MessageFilterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilter = mapped
    }

    /**
     * @param argument The X12 message filter.
     */
    @JvmName("dboeckveejmdahnx")
    public suspend fun messageFilter(argument: suspend X12MessageFilterArgsBuilder.() -> Unit) {
        val toBeMapped = X12MessageFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.messageFilter = mapped
    }

    /**
     * @param value The X12 message filter list.
     */
    @JvmName("hdiywswijxtldugi")
    public suspend fun messageFilterList(`value`: List<X12MessageIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param argument The X12 message filter list.
     */
    @JvmName("cxjavmkvdqnmfafs")
    public suspend
    fun messageFilterList(argument: List<suspend X12MessageIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X12MessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The X12 message filter list.
     */
    @JvmName("phbbkprcwwjvplna")
    public suspend fun messageFilterList(
        vararg
        argument: suspend X12MessageIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X12MessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The X12 message filter list.
     */
    @JvmName("krompxncmvpdelae")
    public suspend
    fun messageFilterList(argument: suspend X12MessageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X12MessageIdentifierArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param values The X12 message filter list.
     */
    @JvmName("tukyubyjypqgcmun")
    public suspend fun messageFilterList(vararg values: X12MessageIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param value The X12 processing settings.
     */
    @JvmName("ajqlexpdjsxofcbv")
    public suspend fun processingSettings(`value`: X12ProcessingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processingSettings = mapped
    }

    /**
     * @param argument The X12 processing settings.
     */
    @JvmName("qbunuddqxobnvjxx")
    public suspend
    fun processingSettings(argument: suspend X12ProcessingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12ProcessingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.processingSettings = mapped
    }

    /**
     * @param value The X12 schema references.
     */
    @JvmName("smnrkygkpuvcffun")
    public suspend fun schemaReferences(`value`: List<X12SchemaReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param argument The X12 schema references.
     */
    @JvmName("vlfgxlahicscavbh")
    public suspend
    fun schemaReferences(argument: List<suspend X12SchemaReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X12SchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The X12 schema references.
     */
    @JvmName("juqnmtxqomyfeylx")
    public suspend fun schemaReferences(
        vararg
        argument: suspend X12SchemaReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X12SchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The X12 schema references.
     */
    @JvmName("idvluxuxapdhubdd")
    public suspend fun schemaReferences(argument: suspend X12SchemaReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X12SchemaReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param values The X12 schema references.
     */
    @JvmName("ngmivvuprnnewlxf")
    public suspend fun schemaReferences(vararg values: X12SchemaReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param value The X12 security settings.
     */
    @JvmName("rsfkyejmqlkqdsuy")
    public suspend fun securitySettings(`value`: X12SecuritySettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument The X12 security settings.
     */
    @JvmName("fftgafdejmtobjgd")
    public suspend fun securitySettings(argument: suspend X12SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value The X12 validation override settings.
     */
    @JvmName("jiitfapgagxmidfn")
    public suspend fun validationOverrides(`value`: List<X12ValidationOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param argument The X12 validation override settings.
     */
    @JvmName("qregfdhmirqukrrp")
    public suspend
    fun validationOverrides(argument: List<suspend X12ValidationOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X12ValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The X12 validation override settings.
     */
    @JvmName("mjoggcvjyobpdnmg")
    public suspend fun validationOverrides(
        vararg
        argument: suspend X12ValidationOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X12ValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The X12 validation override settings.
     */
    @JvmName("hwfndtiuicvnnluw")
    public suspend
    fun validationOverrides(argument: suspend X12ValidationOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X12ValidationOverrideArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param values The X12 validation override settings.
     */
    @JvmName("ixfswgaiskssiqie")
    public suspend fun validationOverrides(vararg values: X12ValidationOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param value The X12 validation settings.
     */
    @JvmName("faqdiearmpvtpxrg")
    public suspend fun validationSettings(`value`: X12ValidationSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationSettings = mapped
    }

    /**
     * @param argument The X12 validation settings.
     */
    @JvmName("hmnlacqejvajjwax")
    public suspend
    fun validationSettings(argument: suspend X12ValidationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12ValidationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationSettings = mapped
    }

    /**
     * @param value The X12 delimiter override settings.
     */
    @JvmName("vedopdhndfkcjpkw")
    public suspend fun x12DelimiterOverrides(`value`: List<X12DelimiterOverridesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x12DelimiterOverrides = mapped
    }

    /**
     * @param argument The X12 delimiter override settings.
     */
    @JvmName("akfojnqbvfftsumq")
    public suspend
    fun x12DelimiterOverrides(argument: List<suspend X12DelimiterOverridesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X12DelimiterOverridesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.x12DelimiterOverrides = mapped
    }

    /**
     * @param argument The X12 delimiter override settings.
     */
    @JvmName("kvklkxgwdtwyyuej")
    public suspend fun x12DelimiterOverrides(
        vararg
        argument: suspend X12DelimiterOverridesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X12DelimiterOverridesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.x12DelimiterOverrides = mapped
    }

    /**
     * @param argument The X12 delimiter override settings.
     */
    @JvmName("pjidslsddobqgjvw")
    public suspend
    fun x12DelimiterOverrides(argument: suspend X12DelimiterOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X12DelimiterOverridesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.x12DelimiterOverrides = mapped
    }

    /**
     * @param values The X12 delimiter override settings.
     */
    @JvmName("fxvxbsqcfnachhfr")
    public suspend fun x12DelimiterOverrides(vararg values: X12DelimiterOverridesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.x12DelimiterOverrides = mapped
    }

    internal fun build(): X12ProtocolSettingsArgs = X12ProtocolSettingsArgs(
        acknowledgementSettings = acknowledgementSettings ?: throw
            PulumiNullFieldException("acknowledgementSettings"),
        envelopeOverrides = envelopeOverrides,
        envelopeSettings = envelopeSettings ?: throw PulumiNullFieldException("envelopeSettings"),
        framingSettings = framingSettings ?: throw PulumiNullFieldException("framingSettings"),
        messageFilter = messageFilter ?: throw PulumiNullFieldException("messageFilter"),
        messageFilterList = messageFilterList,
        processingSettings = processingSettings ?: throw PulumiNullFieldException("processingSettings"),
        schemaReferences = schemaReferences ?: throw PulumiNullFieldException("schemaReferences"),
        securitySettings = securitySettings ?: throw PulumiNullFieldException("securitySettings"),
        validationOverrides = validationOverrides,
        validationSettings = validationSettings ?: throw PulumiNullFieldException("validationSettings"),
        x12DelimiterOverrides = x12DelimiterOverrides,
    )
}
