@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact agreement acknowledgement settings.
 * @property acknowledgementControlNumberLowerBound The acknowledgement control number lower bound.
 * @property acknowledgementControlNumberPrefix The acknowledgement control number prefix.
 * @property acknowledgementControlNumberSuffix The acknowledgement control number suffix.
 * @property acknowledgementControlNumberUpperBound The acknowledgement control number upper bound.
 * @property batchFunctionalAcknowledgements The value indicating whether to batch functional acknowledgements.
 * @property batchTechnicalAcknowledgements The value indicating whether to batch the technical acknowledgements.
 * @property needFunctionalAcknowledgement The value indicating whether functional acknowledgement is needed.
 * @property needLoopForValidMessages The value indicating whether a loop is needed for valid messages.
 * @property needTechnicalAcknowledgement The value indicating whether technical acknowledgement is needed.
 * @property rolloverAcknowledgementControlNumber The value indicating whether to rollover acknowledgement control number.
 * @property sendSynchronousAcknowledgement The value indicating whether to send synchronous acknowledgement.
 */
public data class EdifactAcknowledgementSettingsResponse(
    public val acknowledgementControlNumberLowerBound: Int,
    public val acknowledgementControlNumberPrefix: String? = null,
    public val acknowledgementControlNumberSuffix: String? = null,
    public val acknowledgementControlNumberUpperBound: Int,
    public val batchFunctionalAcknowledgements: Boolean,
    public val batchTechnicalAcknowledgements: Boolean,
    public val needFunctionalAcknowledgement: Boolean,
    public val needLoopForValidMessages: Boolean,
    public val needTechnicalAcknowledgement: Boolean,
    public val rolloverAcknowledgementControlNumber: Boolean,
    public val sendSynchronousAcknowledgement: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactAcknowledgementSettingsResponse):
            EdifactAcknowledgementSettingsResponse = EdifactAcknowledgementSettingsResponse(
            acknowledgementControlNumberLowerBound = javaType.acknowledgementControlNumberLowerBound(),
            acknowledgementControlNumberPrefix = javaType.acknowledgementControlNumberPrefix().map({ args0 ->
                args0
            }).orElse(null),
            acknowledgementControlNumberSuffix = javaType.acknowledgementControlNumberSuffix().map({ args0 ->
                args0
            }).orElse(null),
            acknowledgementControlNumberUpperBound = javaType.acknowledgementControlNumberUpperBound(),
            batchFunctionalAcknowledgements = javaType.batchFunctionalAcknowledgements(),
            batchTechnicalAcknowledgements = javaType.batchTechnicalAcknowledgements(),
            needFunctionalAcknowledgement = javaType.needFunctionalAcknowledgement(),
            needLoopForValidMessages = javaType.needLoopForValidMessages(),
            needTechnicalAcknowledgement = javaType.needTechnicalAcknowledgement(),
            rolloverAcknowledgementControlNumber = javaType.rolloverAcknowledgementControlNumber(),
            sendSynchronousAcknowledgement = javaType.sendSynchronousAcknowledgement(),
        )
    }
}
