@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The Edifact agreement content.
 * @property receiveAgreement The EDIFACT one-way receive agreement.
 * @property sendAgreement The EDIFACT one-way send agreement.
 */
public data class EdifactAgreementContentResponse(
    public val receiveAgreement: EdifactOneWayAgreementResponse,
    public val sendAgreement: EdifactOneWayAgreementResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactAgreementContentResponse):
            EdifactAgreementContentResponse = EdifactAgreementContentResponse(
            receiveAgreement = javaType.receiveAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactOneWayAgreementResponse.Companion.toKotlin(args0)
            }),
            sendAgreement = javaType.sendAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactOneWayAgreementResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
