@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact delimiter override settings.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property decimalPointIndicator The decimal point indicator.
 * @property messageAssociationAssignedCode The message association assigned code.
 * @property messageId The message id.
 * @property messageRelease The message release.
 * @property messageVersion The message version.
 * @property releaseIndicator The release indicator.
 * @property repetitionSeparator The repetition separator.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 * @property targetNamespace The target namespace on which this delimiter settings has to be applied.
 */
public data class EdifactDelimiterOverrideResponse(
    public val componentSeparator: Int,
    public val dataElementSeparator: Int,
    public val decimalPointIndicator: String,
    public val messageAssociationAssignedCode: String? = null,
    public val messageId: String? = null,
    public val messageRelease: String? = null,
    public val messageVersion: String? = null,
    public val releaseIndicator: Int,
    public val repetitionSeparator: Int,
    public val segmentTerminator: Int,
    public val segmentTerminatorSuffix: String,
    public val targetNamespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactDelimiterOverrideResponse):
            EdifactDelimiterOverrideResponse = EdifactDelimiterOverrideResponse(
            componentSeparator = javaType.componentSeparator(),
            dataElementSeparator = javaType.dataElementSeparator(),
            decimalPointIndicator = javaType.decimalPointIndicator(),
            messageAssociationAssignedCode = javaType.messageAssociationAssignedCode().map({ args0 ->
                args0
            }).orElse(null),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            messageRelease = javaType.messageRelease().map({ args0 -> args0 }).orElse(null),
            messageVersion = javaType.messageVersion().map({ args0 -> args0 }).orElse(null),
            releaseIndicator = javaType.releaseIndicator(),
            repetitionSeparator = javaType.repetitionSeparator(),
            segmentTerminator = javaType.segmentTerminator(),
            segmentTerminatorSuffix = javaType.segmentTerminatorSuffix(),
            targetNamespace = javaType.targetNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
