@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact agreement envelope settings.
 * @property applicationReferenceId The application reference id.
 * @property applyDelimiterStringAdvice The value indicating whether to apply delimiter string advice.
 * @property communicationAgreementId The communication agreement id.
 * @property createGroupingSegments The value indicating whether to create grouping segments.
 * @property enableDefaultGroupHeaders The value indicating whether to enable default group headers.
 * @property functionalGroupId The functional group id.
 * @property groupApplicationPassword The group application password.
 * @property groupApplicationReceiverId The group application receiver id.
 * @property groupApplicationReceiverQualifier The group application receiver qualifier.
 * @property groupApplicationSenderId The group application sender id.
 * @property groupApplicationSenderQualifier The group application sender qualifier.
 * @property groupAssociationAssignedCode The group association assigned code.
 * @property groupControlNumberLowerBound The group control number lower bound.
 * @property groupControlNumberPrefix The group control number prefix.
 * @property groupControlNumberSuffix The group control number suffix.
 * @property groupControlNumberUpperBound The group control number upper bound.
 * @property groupControllingAgencyCode The group controlling agency code.
 * @property groupMessageRelease The group message release.
 * @property groupMessageVersion The group message version.
 * @property interchangeControlNumberLowerBound The interchange control number lower bound.
 * @property interchangeControlNumberPrefix The interchange control number prefix.
 * @property interchangeControlNumberSuffix The interchange control number suffix.
 * @property interchangeControlNumberUpperBound The interchange control number upper bound.
 * @property isTestInterchange The value indicating whether the message is a test interchange.
 * @property overwriteExistingTransactionSetControlNumber The value indicating whether to overwrite existing transaction set control number.
 * @property processingPriorityCode The processing priority code.
 * @property receiverInternalIdentification The receiver internal identification.
 * @property receiverInternalSubIdentification The receiver internal sub identification.
 * @property receiverReverseRoutingAddress The receiver reverse routing address.
 * @property recipientReferencePasswordQualifier The recipient reference password qualifier.
 * @property recipientReferencePasswordValue The recipient reference password value.
 * @property rolloverGroupControlNumber The value indicating whether to rollover group control number.
 * @property rolloverInterchangeControlNumber The value indicating whether to rollover interchange control number.
 * @property rolloverTransactionSetControlNumber The value indicating whether to rollover transaction set control number.
 * @property senderInternalIdentification The sender internal identification.
 * @property senderInternalSubIdentification The sender internal sub identification.
 * @property senderReverseRoutingAddress The sender reverse routing address.
 * @property transactionSetControlNumberLowerBound The transaction set control number lower bound.
 * @property transactionSetControlNumberPrefix The transaction set control number prefix.
 * @property transactionSetControlNumberSuffix The transaction set control number suffix.
 * @property transactionSetControlNumberUpperBound The transaction set control number upper bound.
 */
public data class EdifactEnvelopeSettingsResponse(
    public val applicationReferenceId: String? = null,
    public val applyDelimiterStringAdvice: Boolean,
    public val communicationAgreementId: String? = null,
    public val createGroupingSegments: Boolean,
    public val enableDefaultGroupHeaders: Boolean,
    public val functionalGroupId: String? = null,
    public val groupApplicationPassword: String? = null,
    public val groupApplicationReceiverId: String? = null,
    public val groupApplicationReceiverQualifier: String? = null,
    public val groupApplicationSenderId: String? = null,
    public val groupApplicationSenderQualifier: String? = null,
    public val groupAssociationAssignedCode: String? = null,
    public val groupControlNumberLowerBound: Double,
    public val groupControlNumberPrefix: String? = null,
    public val groupControlNumberSuffix: String? = null,
    public val groupControlNumberUpperBound: Double,
    public val groupControllingAgencyCode: String? = null,
    public val groupMessageRelease: String? = null,
    public val groupMessageVersion: String? = null,
    public val interchangeControlNumberLowerBound: Double,
    public val interchangeControlNumberPrefix: String? = null,
    public val interchangeControlNumberSuffix: String? = null,
    public val interchangeControlNumberUpperBound: Double,
    public val isTestInterchange: Boolean,
    public val overwriteExistingTransactionSetControlNumber: Boolean,
    public val processingPriorityCode: String? = null,
    public val receiverInternalIdentification: String? = null,
    public val receiverInternalSubIdentification: String? = null,
    public val receiverReverseRoutingAddress: String? = null,
    public val recipientReferencePasswordQualifier: String? = null,
    public val recipientReferencePasswordValue: String? = null,
    public val rolloverGroupControlNumber: Boolean,
    public val rolloverInterchangeControlNumber: Boolean,
    public val rolloverTransactionSetControlNumber: Boolean,
    public val senderInternalIdentification: String? = null,
    public val senderInternalSubIdentification: String? = null,
    public val senderReverseRoutingAddress: String? = null,
    public val transactionSetControlNumberLowerBound: Double,
    public val transactionSetControlNumberPrefix: String? = null,
    public val transactionSetControlNumberSuffix: String? = null,
    public val transactionSetControlNumberUpperBound: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactEnvelopeSettingsResponse):
            EdifactEnvelopeSettingsResponse = EdifactEnvelopeSettingsResponse(
            applicationReferenceId = javaType.applicationReferenceId().map({ args0 -> args0 }).orElse(null),
            applyDelimiterStringAdvice = javaType.applyDelimiterStringAdvice(),
            communicationAgreementId = javaType.communicationAgreementId().map({ args0 -> args0 }).orElse(null),
            createGroupingSegments = javaType.createGroupingSegments(),
            enableDefaultGroupHeaders = javaType.enableDefaultGroupHeaders(),
            functionalGroupId = javaType.functionalGroupId().map({ args0 -> args0 }).orElse(null),
            groupApplicationPassword = javaType.groupApplicationPassword().map({ args0 -> args0 }).orElse(null),
            groupApplicationReceiverId = javaType.groupApplicationReceiverId().map({ args0 ->
                args0
            }).orElse(null),
            groupApplicationReceiverQualifier = javaType.groupApplicationReceiverQualifier().map({ args0 ->
                args0
            }).orElse(null),
            groupApplicationSenderId = javaType.groupApplicationSenderId().map({ args0 -> args0 }).orElse(null),
            groupApplicationSenderQualifier = javaType.groupApplicationSenderQualifier().map({ args0 ->
                args0
            }).orElse(null),
            groupAssociationAssignedCode = javaType.groupAssociationAssignedCode().map({ args0 ->
                args0
            }).orElse(null),
            groupControlNumberLowerBound = javaType.groupControlNumberLowerBound(),
            groupControlNumberPrefix = javaType.groupControlNumberPrefix().map({ args0 -> args0 }).orElse(null),
            groupControlNumberSuffix = javaType.groupControlNumberSuffix().map({ args0 -> args0 }).orElse(null),
            groupControlNumberUpperBound = javaType.groupControlNumberUpperBound(),
            groupControllingAgencyCode = javaType.groupControllingAgencyCode().map({ args0 ->
                args0
            }).orElse(null),
            groupMessageRelease = javaType.groupMessageRelease().map({ args0 -> args0 }).orElse(null),
            groupMessageVersion = javaType.groupMessageVersion().map({ args0 -> args0 }).orElse(null),
            interchangeControlNumberLowerBound = javaType.interchangeControlNumberLowerBound(),
            interchangeControlNumberPrefix = javaType.interchangeControlNumberPrefix().map({ args0 ->
                args0
            }).orElse(null),
            interchangeControlNumberSuffix = javaType.interchangeControlNumberSuffix().map({ args0 ->
                args0
            }).orElse(null),
            interchangeControlNumberUpperBound = javaType.interchangeControlNumberUpperBound(),
            isTestInterchange = javaType.isTestInterchange(),
            overwriteExistingTransactionSetControlNumber = javaType.overwriteExistingTransactionSetControlNumber(),
            processingPriorityCode = javaType.processingPriorityCode().map({ args0 -> args0 }).orElse(null),
            receiverInternalIdentification = javaType.receiverInternalIdentification().map({ args0 ->
                args0
            }).orElse(null),
            receiverInternalSubIdentification = javaType.receiverInternalSubIdentification().map({ args0 ->
                args0
            }).orElse(null),
            receiverReverseRoutingAddress = javaType.receiverReverseRoutingAddress().map({ args0 ->
                args0
            }).orElse(null),
            recipientReferencePasswordQualifier = javaType.recipientReferencePasswordQualifier().map({ args0 ->
                args0
            }).orElse(null),
            recipientReferencePasswordValue = javaType.recipientReferencePasswordValue().map({ args0 ->
                args0
            }).orElse(null),
            rolloverGroupControlNumber = javaType.rolloverGroupControlNumber(),
            rolloverInterchangeControlNumber = javaType.rolloverInterchangeControlNumber(),
            rolloverTransactionSetControlNumber = javaType.rolloverTransactionSetControlNumber(),
            senderInternalIdentification = javaType.senderInternalIdentification().map({ args0 ->
                args0
            }).orElse(null),
            senderInternalSubIdentification = javaType.senderInternalSubIdentification().map({ args0 ->
                args0
            }).orElse(null),
            senderReverseRoutingAddress = javaType.senderReverseRoutingAddress().map({ args0 ->
                args0
            }).orElse(null),
            transactionSetControlNumberLowerBound = javaType.transactionSetControlNumberLowerBound(),
            transactionSetControlNumberPrefix = javaType.transactionSetControlNumberPrefix().map({ args0 ->
                args0
            }).orElse(null),
            transactionSetControlNumberSuffix = javaType.transactionSetControlNumberSuffix().map({ args0 ->
                args0
            }).orElse(null),
            transactionSetControlNumberUpperBound = javaType.transactionSetControlNumberUpperBound(),
        )
    }
}
