@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The Edifact agreement protocol settings.
 * @property acknowledgementSettings The EDIFACT acknowledgement settings.
 * @property edifactDelimiterOverrides The EDIFACT delimiter override settings.
 * @property envelopeOverrides The EDIFACT envelope override settings.
 * @property envelopeSettings The EDIFACT envelope settings.
 * @property framingSettings The EDIFACT framing settings.
 * @property messageFilter The EDIFACT message filter.
 * @property messageFilterList The EDIFACT message filter list.
 * @property processingSettings The EDIFACT processing Settings.
 * @property schemaReferences The EDIFACT schema references.
 * @property validationOverrides The EDIFACT validation override settings.
 * @property validationSettings The EDIFACT validation settings.
 */
public data class EdifactProtocolSettingsResponse(
    public val acknowledgementSettings: EdifactAcknowledgementSettingsResponse,
    public val edifactDelimiterOverrides: List<EdifactDelimiterOverrideResponse>? = null,
    public val envelopeOverrides: List<EdifactEnvelopeOverrideResponse>? = null,
    public val envelopeSettings: EdifactEnvelopeSettingsResponse,
    public val framingSettings: EdifactFramingSettingsResponse,
    public val messageFilter: EdifactMessageFilterResponse,
    public val messageFilterList: List<EdifactMessageIdentifierResponse>? = null,
    public val processingSettings: EdifactProcessingSettingsResponse,
    public val schemaReferences: List<EdifactSchemaReferenceResponse>,
    public val validationOverrides: List<EdifactValidationOverrideResponse>? = null,
    public val validationSettings: EdifactValidationSettingsResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactProtocolSettingsResponse):
            EdifactProtocolSettingsResponse = EdifactProtocolSettingsResponse(
            acknowledgementSettings = javaType.acknowledgementSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactAcknowledgementSettingsResponse.Companion.toKotlin(args0)
            }),
            edifactDelimiterOverrides = javaType.edifactDelimiterOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactDelimiterOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            envelopeOverrides = javaType.envelopeOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactEnvelopeOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            envelopeSettings = javaType.envelopeSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactEnvelopeSettingsResponse.Companion.toKotlin(args0)
            }),
            framingSettings = javaType.framingSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactFramingSettingsResponse.Companion.toKotlin(args0)
            }),
            messageFilter = javaType.messageFilter().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactMessageFilterResponse.Companion.toKotlin(args0)
            }),
            messageFilterList = javaType.messageFilterList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactMessageIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
            processingSettings = javaType.processingSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactProcessingSettingsResponse.Companion.toKotlin(args0)
            }),
            schemaReferences = javaType.schemaReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactSchemaReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            validationOverrides = javaType.validationOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactValidationOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            validationSettings = javaType.validationSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactValidationSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
