@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact agreement validation settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property checkDuplicateGroupControlNumber The value indicating whether to check for duplicate group control number.
 * @property checkDuplicateInterchangeControlNumber The value indicating whether to check for duplicate interchange control number.
 * @property checkDuplicateTransactionSetControlNumber The value indicating whether to check for duplicate transaction set control number.
 * @property interchangeControlNumberValidityDays The validity period of interchange control number.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateCharacterSet The value indicating whether to validate character set in the message.
 * @property validateEDITypes The value indicating whether to Whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to Whether to validate XSD types.
 */
public data class EdifactValidationSettingsResponse(
    public val allowLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val checkDuplicateGroupControlNumber: Boolean,
    public val checkDuplicateInterchangeControlNumber: Boolean,
    public val checkDuplicateTransactionSetControlNumber: Boolean,
    public val interchangeControlNumberValidityDays: Int,
    public val trailingSeparatorPolicy: String,
    public val trimLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val validateCharacterSet: Boolean,
    public val validateEDITypes: Boolean,
    public val validateXSDTypes: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactValidationSettingsResponse):
            EdifactValidationSettingsResponse = EdifactValidationSettingsResponse(
            allowLeadingAndTrailingSpacesAndZeroes = javaType.allowLeadingAndTrailingSpacesAndZeroes(),
            checkDuplicateGroupControlNumber = javaType.checkDuplicateGroupControlNumber(),
            checkDuplicateInterchangeControlNumber = javaType.checkDuplicateInterchangeControlNumber(),
            checkDuplicateTransactionSetControlNumber = javaType.checkDuplicateTransactionSetControlNumber(),
            interchangeControlNumberValidityDays = javaType.interchangeControlNumberValidityDays(),
            trailingSeparatorPolicy = javaType.trailingSeparatorPolicy(),
            trimLeadingAndTrailingSpacesAndZeroes = javaType.trimLeadingAndTrailingSpacesAndZeroes(),
            validateCharacterSet = javaType.validateCharacterSet(),
            validateEDITypes = javaType.validateEDITypes(),
            validateXSDTypes = javaType.validateXSDTypes(),
        )
    }
}
