@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The reference to the key vault key.
 * @property keyName The private key name in key vault.
 * @property keyVault The key vault reference.
 * @property keyVersion The private key version in key vault.
 */
public data class KeyVaultKeyReferenceResponse(
    public val keyName: String,
    public val keyVault: KeyVaultKeyReferenceResponseKeyVault,
    public val keyVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.KeyVaultKeyReferenceResponse):
            KeyVaultKeyReferenceResponse = KeyVaultKeyReferenceResponse(
            keyName = javaType.keyName(),
            keyVault = javaType.keyVault().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.KeyVaultKeyReferenceResponseKeyVault.Companion.toKotlin(args0)
            }),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
