@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The workflow trigger callback URL.
 * @property basePath Gets the workflow trigger callback URL base path.
 * @property method Gets the workflow trigger callback URL HTTP method.
 * @property queries Gets the workflow trigger callback URL query parameters.
 * @property relativePath Gets the workflow trigger callback URL relative path.
 * @property relativePathParameters Gets the workflow trigger callback URL relative path parameters.
 * @property value Gets the workflow trigger callback URL.
 */
public data class ListWorkflowVersionTriggerCallbackUrlResult(
    public val basePath: String,
    public val method: String,
    public val queries: WorkflowTriggerListCallbackUrlQueriesResponse? = null,
    public val relativePath: String,
    public val relativePathParameters: List<String>? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ListWorkflowVersionTriggerCallbackUrlResult):
            ListWorkflowVersionTriggerCallbackUrlResult = ListWorkflowVersionTriggerCallbackUrlResult(
            basePath = javaType.basePath(),
            method = javaType.method(),
            queries = javaType.queries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.WorkflowTriggerListCallbackUrlQueriesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            relativePath = javaType.relativePath(),
            relativePathParameters = javaType.relativePathParameters().map({ args0 -> args0 }),
            `value` = javaType.`value`(),
        )
    }
}
