@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.logz.kotlin.outputs.MonitorPropertiesResponse
import com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logz.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.MonitorPropertiesResponse.Companion.toKotlin as monitorPropertiesResponseToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MetricsSource].
 */
@PulumiTagMarker
public class MetricsSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricsSourceArgs = MetricsSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricsSourceArgsBuilder.() -> Unit) {
        val builder = MetricsSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MetricsSource {
        val builtJavaResource = com.pulumi.azurenative.logz.MetricsSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricsSource(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * ## Example Usage
 * ### metricsSource_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricsSource = new AzureNative.Logz.MetricsSource("metricsSource", new()
 *     {
 *         MetricsSourceName = "MetricsSource1",
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewMetricsSource(ctx, "metricsSource", &logz.MetricsSourceArgs{
 * 			MetricsSourceName: pulumi.String("MetricsSource1"),
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.MetricsSource;
 * import com.pulumi.azurenative.logz.MetricsSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricsSource = new MetricsSource("metricsSource", MetricsSourceArgs.builder()
 *             .metricsSourceName("MetricsSource1")
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:MetricsSource myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/metricsSource/{metricsSourceName}
 * ```
 */
public class MetricsSource internal constructor(
    override val javaResource: com.pulumi.azurenative.logz.MetricsSource,
) : KotlinCustomResource(javaResource, MetricsSourceMapper) {
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the monitor resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties specific to the monitor resource.
     */
    public val properties: Output<MonitorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                monitorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the monitor resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MetricsSourceMapper : ResourceMapper<MetricsSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logz.MetricsSource::class == javaResource::class

    override fun map(javaResource: Resource): MetricsSource = MetricsSource(
        javaResource as
            com.pulumi.azurenative.logz.MetricsSource,
    )
}

/**
 * @see [MetricsSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricsSource].
 */
public suspend fun metricsSource(
    name: String,
    block: suspend MetricsSourceResourceBuilder.() -> Unit,
): MetricsSource {
    val builder = MetricsSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricsSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricsSource(name: String): MetricsSource {
    val builder = MetricsSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
